/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabPresentationUtil {
    @NotNull
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        for (EditorTabTitleProvider provider : DumbService.getDumbAwareExtensions((Project)project, EditorTabTitleProvider.EP_NAME)) {
            String result2 = provider.getEditorTabTitle(project, file2, editorWindow);
            if (!StringUtil.isNotEmpty((String)result2)) continue;
            return result2;
        }
        return file2.getPresentableName();
    }

    @NotNull
    public static String getUniqueEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        String name = EditorTabPresentationUtil.getEditorTabTitle(project, file2, editorWindow);
        if (name.equals(file2.getPresentableName())) {
            return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2);
        }
        return name;
    }

    @Nullable
    public static Color getEditorTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow editorWindow) {
        for (EditorTabColorProvider provider : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider.getEditorTabColor(project, file2, editorWindow);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        for (EditorTabColorProvider provider : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider.getProjectViewColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

