/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FileChooserAction
extends AnAction
implements DumbAware {
    protected FileChooserAction() {
        this.setEnabledInModalContext(true);
    }

    protected FileChooserAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon2) {
        this(() -> text, () -> description, icon2);
    }

    protected FileChooserAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, Icon icon2) {
        super(text, description, icon2);
        this.setEnabledInModalContext(true);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        FileSystemTree tree = (FileSystemTree)e.getData(FileSystemTree.DATA_KEY);
        this.actionPerformed(tree, e);
    }

    public final void update(@NotNull AnActionEvent e) {
        FileSystemTree tree = (FileSystemTree)e.getData(FileSystemTree.DATA_KEY);
        if (tree != null) {
            e.getPresentation().setEnabled(true);
            this.update(tree, e);
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    protected abstract void update(FileSystemTree var1, AnActionEvent var2);

    protected abstract void actionPerformed(FileSystemTree var1, AnActionEvent var2);
}

