/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    private String myTooltipCache;
    private ModuleNode effectiveRoot = null;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> projectDataNode) {
        super(externalProjectsView, null, projectDataNode);
        this.updateProject();
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        this.setIdeGrouping(null);
        List<ExternalSystemNode<?>> children2 = super.doBuildChildren();
        List visibleChildren = ContainerUtil.filter(children2, node -> node.isVisible());
        if (this.getExternalProjectsView().getGroupModules()) {
            ExternalSystemNode child2;
            List topLevelChildren = ContainerUtil.filter((Collection)visibleChildren, node -> !(node instanceof ModuleNode) || ((ModuleNode)node).getIdeParentGrouping() == null);
            if (topLevelChildren.size() == 1 && (child2 = (ExternalSystemNode)topLevelChildren.get(0)) instanceof ModuleNode) {
                this.effectiveRoot = (ModuleNode)child2;
                return this.effectiveRoot.doBuildChildren();
            }
            return topLevelChildren;
        }
        this.effectiveRoot = null;
        return visibleChildren;
    }

    void updateProject() {
        this.myTooltipCache = this.makeDescription();
        this.getStructure().updateFrom(this.getParent());
    }

    @Override
    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), this.myTooltipCache);
    }

    private String makeDescription() {
        StringBuilder desc = new StringBuilder();
        ProjectData projectData2 = (ProjectData)this.getData();
        desc.append("Project: ").append(this.getName()).append(projectData2 != null ? "\n\rLocation: " + projectData2.getLinkedExternalProjectPath() : "").append(projectData2 != null && !StringUtil.isEmptyOrSpaces((String)projectData2.getDescription()) ? "\n\r" + projectData2.getDescription() : "");
        return desc.toString();
    }

    @Nullable
    public String getIdeGrouping() {
        ProjectData data2 = (ProjectData)this.getData();
        if (data2 == null) {
            return null;
        }
        return data2.getIdeGrouping();
    }

    private void setIdeGrouping(@Nullable String ideGrouping) {
        ProjectData data2 = (ProjectData)this.getData();
        if (data2 != null) {
            data2.setIdeGrouping(ideGrouping);
        }
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    public ModuleNode getEffectiveRoot() {
        return this.effectiveRoot;
    }
}

