/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathLookupElement
extends LookupElement {
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectPath;

    public ExternalProjectPathLookupElement(@NotNull String projectName, @NotNull String projectPath) {
        this.myProjectName = projectName;
        this.myProjectPath = projectPath;
    }

    @NotNull
    public String getLookupString() {
        return this.myProjectName;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        Editor editor = context.getEditor();
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion[] regions;
            for (FoldRegion region : regions = foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(region);
            }
        });
        Document document = editor.getDocument();
        int startOffset = context.getStartOffset();
        document.replaceString(startOffset, document.getTextLength(), (CharSequence)this.myProjectPath);
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, startOffset + this.myProjectPath.length(), this.myProjectName);
            if (region != null) {
                region.setExpanded(false);
            }
        });
    }
}

