/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTree;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathLookupElement;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathField
extends ComponentWithBrowseButton<MyPathAndProjectButtonPanel>
implements TextAccessor {
    @NotNull
    private static final String PROJECT_FILE_TO_START_WITH_KEY = "external.system.task.project.file.to.start";
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalProjectPathField(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull FileChooserDescriptor descriptor2, @NotNull String fileChooserTitle) {
        super((JComponent)ExternalProjectPathField.createPanel(project, externalSystemId), (ActionListener)new MyBrowseListener(descriptor2, fileChooserTitle, project));
        ActionListener[] listeners;
        for (ActionListener listener2 : listeners = this.getButton().getActionListeners()) {
            if (!(listener2 instanceof MyBrowseListener)) continue;
            ((MyBrowseListener)listener2).setPathField(((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField());
            break;
        }
        this.myProject = project;
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public static MyPathAndProjectButtonPanel createPanel(final @NotNull Project project, final @NotNull ProjectSystemId externalSystemId) {
        final EditorTextField textField2 = ExternalProjectPathField.createTextField(project, externalSystemId);
        final FixedSizeButton selectRegisteredProjectButton = new FixedSizeButton();
        selectRegisteredProjectButton.setIcon(AllIcons.Nodes.Module);
        String tooltipText = ExternalSystemBundle.message((String)"run.configuration.tooltip.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()});
        selectRegisteredProjectButton.setToolTipText(tooltipText);
        selectRegisteredProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ref popupRef = new Ref();
                Tree tree = ExternalProjectPathField.buildRegisteredProjectsTree(project, externalSystemId);
                tree.setBorder(JBUI.Borders.empty((int)8));
                Runnable treeSelectionCallback = () -> {
                    Object e1;
                    Object lastPathComponent;
                    TreePath path = tree.getSelectionPath();
                    if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof ExternalSystemNode && (e1 = ((ExternalSystemNode)lastPathComponent).getDescriptor().getElement()) instanceof ExternalProjectPojo) {
                        ExternalProjectPojo pojo = (ExternalProjectPojo)e1;
                        textField2.setText(pojo.getPath());
                        Editor editor = textField2.getEditor();
                        if (editor != null) {
                            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project);
                        }
                    }
                    ((JBPopup)popupRef.get()).closeOk(null);
                };
                JBPopup popup2 = new PopupChooserBuilder((JTree)tree).setTitle(ExternalSystemBundle.message((String)"run.configuration.title.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()})).setResizable(true).setItemChoosenCallback(treeSelectionCallback).setAutoselectOnMouseMove(true).setCloseOnEnter(false).createPopup();
                popupRef.set((Object)popup2);
                popup2.showUnderneathOf((Component)selectRegisteredProjectButton);
            }
        });
        return new MyPathAndProjectButtonPanel(textField2, selectRegisteredProjectButton);
    }

    @NotNull
    private static Tree buildRegisteredProjectsTree(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        ExternalSystemTasksTreeModel model = new ExternalSystemTasksTreeModel(externalSystemId);
        ExternalSystemTasksTree result2 = new ExternalSystemTasksTree(model, new HashMap<String, Boolean>(), project, externalSystemId);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        Map projects = settings.getAvailableProjects();
        ArrayList rootProjects = new ArrayList(projects.keySet());
        ContainerUtil.sort(rootProjects);
        for (ExternalProjectPojo rootProject : rootProjects) {
            model.ensureSubProjectsStructure(rootProject, (Collection)projects.get(rootProject));
        }
        return result2;
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        final AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        final ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        TextFieldCompletionProviderDumbAware provider = new TextFieldCompletionProviderDumbAware(){

            @Override
            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
                    String rootProjectPath = ((ExternalProjectPojo)entry.getKey()).getPath();
                    String rootProjectName = uiAware.getProjectRepresentationName(rootProjectPath, null);
                    ExternalProjectPathLookupElement rootProjectElement = new ExternalProjectPathLookupElement(rootProjectName, rootProjectPath);
                    result2.addElement((LookupElement)rootProjectElement);
                    for (ExternalProjectPojo subProject : (Collection)entry.getValue()) {
                        String p = subProject.getPath();
                        if (rootProjectPath.equals(p)) continue;
                        String subProjectName = uiAware.getProjectRepresentationName(p, rootProjectPath);
                        ExternalProjectPathLookupElement subProjectElement = new ExternalProjectPathLookupElement(subProjectName, p);
                        result2.addElement((LookupElement)subProjectElement);
                    }
                }
                result2.stopHere();
            }
        };
        EditorTextField result2 = provider.createEditor(project, true, (Consumer<Editor>)((Consumer)editor -> {
            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project);
            editor.getSettings().setShowIntentionBulb(false);
        }));
        result2.setOneLineMode(true);
        result2.setOpaque(true);
        result2.setBackground(UIUtil.getTextFieldBackground());
        return result2;
    }

    public void setText(String text) {
        ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().setText(text);
        Editor editor = ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getEditor();
        if (editor != null) {
            ExternalProjectPathField.collapseIfPossible(editor, this.myExternalSystemId, this.myProject);
        }
    }

    private static void collapseIfPossible(@NotNull Editor editor, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        String rawText = editor.getDocument().getText();
        for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
            if (((ExternalProjectPojo)entry.getKey()).getPath().equals(rawText)) {
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(project, ((ExternalProjectPojo)entry.getKey()).getPath(), null));
                return;
            }
            for (ExternalProjectPojo pojo : (Collection)entry.getValue()) {
                if (!pojo.getPath().equals(rawText)) continue;
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(project, pojo.getPath(), ((ExternalProjectPojo)entry.getKey()).getPath()));
                return;
            }
        }
    }

    public static void collapse(@NotNull Editor editor, @NotNull String placeholder) {
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(region);
            }
            FoldRegion region = foldingModel.addFoldRegion(0, editor.getDocument().getTextLength(), placeholder);
            if (region != null) {
                region.setExpanded(false);
            }
        });
    }

    public String getText() {
        return ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getText();
    }

    public static class MyPathAndProjectButtonPanel
    extends JPanel {
        @NotNull
        private final EditorTextField myTextField;
        @NotNull
        private final FixedSizeButton myRegisteredProjectsButton;

        public MyPathAndProjectButtonPanel(@NotNull EditorTextField textField2, @NotNull FixedSizeButton registeredProjectsButton) {
            super(new GridBagLayout());
            this.myTextField = textField2;
            this.myRegisteredProjectsButton = registeredProjectsButton;
            this.add((Component)((Object)this.myTextField), new GridBag().weightx(1.0).fillCellHorizontally());
            this.add((Component)this.myRegisteredProjectsButton, new GridBag().insets(0, 3, 0, 1));
        }

        @NotNull
        public EditorTextField getTextField() {
            return this.myTextField;
        }
    }

    private static class MyBrowseListener
    implements ActionListener {
        @NotNull
        private final FileChooserDescriptor myDescriptor;
        @NotNull
        private final Project myProject;
        private EditorTextField myPathField;

        MyBrowseListener(@NotNull FileChooserDescriptor descriptor2, @NotNull String fileChooserTitle, @NotNull Project project) {
            descriptor2.setTitle(fileChooserTitle);
            this.myDescriptor = descriptor2;
            this.myProject = project;
        }

        private void setPathField(@NotNull EditorTextField pathField) {
            this.myPathField = pathField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile file2;
            if (this.myPathField == null) {
                assert (false);
                return;
            }
            PropertiesComponent component2 = PropertiesComponent.getInstance((Project)this.myProject);
            String pathToStart = this.myPathField.getText();
            if (StringUtil.isEmpty((String)pathToStart)) {
                pathToStart = component2.getValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY);
            }
            VirtualFile fileToStart = null;
            if (!StringUtil.isEmpty((String)pathToStart)) {
                fileToStart = LocalFileSystem.getInstance().findFileByPath(pathToStart);
            }
            if ((file2 = FileChooser.chooseFile((FileChooserDescriptor)this.myDescriptor, (Project)this.myProject, (VirtualFile)fileToStart)) != null) {
                String path = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2);
                this.myPathField.setText(path);
                component2.setValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY, path);
            }
        }
    }
}

