/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNodeDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTasksTreeModel
extends DefaultTreeModel {
    @NotNull
    private static final Comparator<TreeNode> NODE_COMPARATOR = (t1, t2) -> {
        Object e1 = ((ExternalSystemNode)t1).getDescriptor().getElement();
        Object e2 = ((ExternalSystemNode)t2).getDescriptor().getElement();
        if (e1 instanceof ExternalProjectPojo) {
            if (e2 instanceof ExternalTaskExecutionInfo) {
                return 1;
            }
            return ((ExternalProjectPojo)e1).getName().compareTo(((ExternalProjectPojo)e2).getName());
        }
        if (e2 instanceof ExternalProjectPojo) {
            return -1;
        }
        return ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e1).compareTo(ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e2));
    };
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalSystemTasksTreeModel(@NotNull ProjectSystemId externalSystemId) {
        super(new ExternalSystemNode<String>(new ExternalSystemNodeDescriptor<String>("", "", "", null)));
        this.myExternalSystemId = externalSystemId;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
    }

    private static String getTaskName(@NotNull ExternalTaskExecutionInfo taskInfo) {
        return (String)taskInfo.getSettings().getTaskNames().get(0);
    }

    @NotNull
    public ExternalSystemNode<ExternalProjectPojo> ensureProjectNodeExists(@NotNull ExternalProjectPojo project) {
        Object root = this.getRoot();
        for (int i2 = ((DefaultMutableTreeNode)root).getChildCount() - 1; i2 >= 0; --i2) {
            ExternalProjectPojo pojo;
            TreeNode child2 = ((ExternalSystemNode)root).getChildAt(i2);
            ExternalSystemNodeDescriptor descriptor2 = ((ExternalSystemNode)child2).getDescriptor();
            Object element2 = descriptor2.getElement();
            if (!(element2 instanceof ExternalProjectPojo) || !(pojo = (ExternalProjectPojo)element2).getPath().equals(project.getPath())) continue;
            if (!pojo.getName().equals(project.getName())) {
                pojo.setName(project.getName());
                descriptor2.setName(project.getName());
                this.nodeChanged(child2);
            }
            return child2;
        }
        ExternalProjectPojo element3 = new ExternalProjectPojo(project.getName(), project.getPath());
        ExternalSystemNodeDescriptor<ExternalProjectPojo> descriptor3 = ExternalSystemTasksTreeModel.descriptor(element3, this.myUiAware.getProjectIcon());
        ExternalSystemNode<ExternalProjectPojo> result2 = new ExternalSystemNode<ExternalProjectPojo>(descriptor3);
        this.insertNodeInto(result2, (MutableTreeNode)root);
        return result2;
    }

    public void pruneNodes(@NotNull Object payload) {
        ArrayDeque<Object> toProcess2 = new ArrayDeque<Object>();
        toProcess2.addFirst(this.getRoot());
        while (!toProcess2.isEmpty()) {
            ExternalSystemNode node = (ExternalSystemNode)toProcess2.removeLast();
            if (payload.equals(node.getDescriptor().getElement())) {
                this.removeNodeFromParent(node);
                continue;
            }
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                toProcess2.addFirst(node.getChildAt(i2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ensureSubProjectsStructure(@NotNull ExternalProjectPojo topLevelProject, @NotNull Collection<? extends ExternalProjectPojo> subProjects) {
        void var6_8;
        ExternalSystemNode<ExternalProjectPojo> topLevelProjectNode = this.ensureProjectNodeExists(topLevelProject);
        HashMap<String, ExternalProjectPojo> toAdd = new HashMap<String, ExternalProjectPojo>();
        for (ExternalProjectPojo externalProjectPojo : subProjects) {
            toAdd.put(externalProjectPojo.getPath(), externalProjectPojo);
        }
        toAdd.remove(topLevelProject.getPath());
        TObjectIntHashMap taskWeights = new TObjectIntHashMap();
        boolean bl = false;
        while (var6_8 < topLevelProjectNode.getChildCount()) {
            TreeNode child2 = topLevelProjectNode.getChildAt((int)var6_8);
            Object childElement = ((ExternalSystemNode)child2).getDescriptor().getElement();
            if (childElement instanceof ExternalTaskExecutionInfo) {
                taskWeights.put(childElement, subProjects.size() + var6_8);
            } else if (toAdd.remove(((ExternalProjectPojo)childElement).getPath()) == null) {
                this.removeNodeFromParent((MutableTreeNode)child2);
                --var6_8;
            }
            ++var6_8;
        }
        if (!toAdd.isEmpty()) {
            for (Map.Entry entry : toAdd.entrySet()) {
                ExternalProjectPojo element2 = new ExternalProjectPojo(((ExternalProjectPojo)entry.getValue()).getName(), ((ExternalProjectPojo)entry.getValue()).getPath());
                this.insertNodeInto(new ExternalSystemNode<ExternalProjectPojo>(ExternalSystemTasksTreeModel.descriptor(element2, this.myUiAware.getProjectIcon())), topLevelProjectNode);
            }
        }
    }

    public void ensureTasks(@NotNull String externalProjectConfigPath, @NotNull Collection<? extends ExternalTaskPojo> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        ExternalSystemNode<ExternalProjectPojo> moduleNode = this.findProjectNode(externalProjectConfigPath);
        if (moduleNode == null) {
            return;
        }
        HashSet<ExternalTaskExecutionInfo> toAdd = new HashSet<ExternalTaskExecutionInfo>();
        for (ExternalTaskPojo externalTaskPojo : tasks) {
            toAdd.add(this.buildTaskInfo(externalTaskPojo));
        }
        for (int i2 = 0; i2 < moduleNode.getChildCount(); ++i2) {
            TreeNode treeNode = moduleNode.getChildAt(i2);
            Object element2 = ((ExternalSystemNode)treeNode).getDescriptor().getElement();
            if (!(element2 instanceof ExternalTaskExecutionInfo) || toAdd.remove(element2)) continue;
            this.removeNodeFromParent((MutableTreeNode)treeNode);
            --i2;
        }
        if (!toAdd.isEmpty()) {
            for (ExternalTaskExecutionInfo externalTaskExecutionInfo : toAdd) {
                this.insertNodeInto(new ExternalSystemNode<ExternalTaskExecutionInfo>(ExternalSystemTasksTreeModel.descriptor(externalTaskExecutionInfo, externalTaskExecutionInfo.getDescription(), this.myUiAware.getTaskIcon())), moduleNode);
            }
        }
    }

    @NotNull
    private ExternalTaskExecutionInfo buildTaskInfo(@NotNull ExternalTaskPojo task2) {
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task2.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task2.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task2.getDescription()));
        settings.setExternalSystemIdString(this.myExternalSystemId.toString());
        return new ExternalTaskExecutionInfo(settings, "Run");
    }

    @Nullable
    private ExternalSystemNode<ExternalProjectPojo> findProjectNode(@NotNull String configPath) {
        for (int i2 = ((DefaultMutableTreeNode)this.getRoot()).getChildCount() - 1; i2 >= 0; --i2) {
            TreeNode child2 = ((ExternalSystemNode)this.getRoot()).getChildAt(i2);
            Object childElement = ((ExternalSystemNode)child2).getDescriptor().getElement();
            if (childElement instanceof ExternalProjectPojo && ((ExternalProjectPojo)childElement).getPath().equals(configPath)) {
                return child2;
            }
            for (int j = ((DefaultMutableTreeNode)child2).getChildCount() - 1; j >= 0; --j) {
                TreeNode grandChild = ((ExternalSystemNode)child2).getChildAt(j);
                Object grandChildElement = ((ExternalSystemNode)grandChild).getDescriptor().getElement();
                if (!(grandChildElement instanceof ExternalProjectPojo) || !((ExternalProjectPojo)grandChildElement).getPath().equals(configPath)) continue;
                return grandChild;
            }
        }
        return null;
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element2, @Nullable Icon icon2) {
        return ExternalSystemTasksTreeModel.descriptor(element2, "", icon2);
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element2, @NotNull String description, @Nullable Icon icon2) {
        return new ExternalSystemNodeDescriptor<T>(element2, element2.toString(), description, icon2);
    }

    @Override
    @NotNull
    public ExternalSystemNode<?> getRoot() {
        return (ExternalSystemNode)super.getRoot();
    }

    public void insertNodeInto(MutableTreeNode child2, MutableTreeNode parent) {
        int index = ExternalSystemTasksTreeModel.findIndexFor(child2, parent);
        super.insertNodeInto(child2, parent, index);
    }

    @Override
    public void insertNodeInto(MutableTreeNode child2, MutableTreeNode parent, int i2) {
        this.insertNodeInto(child2, parent);
    }

    private static int findIndexFor(MutableTreeNode child2, MutableTreeNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return NODE_COMPARATOR.compare(child2, parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, 0, childCount - 1);
    }

    private static int findIndexFor(MutableTreeNode child2, MutableTreeNode parent, int i1, int i2) {
        if (i1 == i2) {
            return NODE_COMPARATOR.compare(child2, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
        }
        int half = (i1 + i2) / 2;
        if (NODE_COMPARATOR.compare(child2, parent.getChildAt(half)) <= 0) {
            return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, i1, half);
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, half + 1, i2);
    }
}

