/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemProjectResolverWrapper;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemTaskManagerWrapper;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemFacadeWrapper<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemFacade<S> {
    @NotNull
    private final RemoteExternalSystemFacade<S> myDelegate;
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;

    public ExternalSystemFacadeWrapper(@NotNull RemoteExternalSystemFacade<S> delegate, @NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        this.myDelegate = delegate;
        this.myProgressManager = progressManager;
    }

    @NotNull
    public RemoteExternalSystemFacade<S> getDelegate() {
        return this.myDelegate;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() throws RemoteException, IllegalStateException {
        return new ExternalSystemProjectResolverWrapper<S>(this.myDelegate.getResolver(), this.myProgressManager);
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() throws RemoteException {
        return new ExternalSystemTaskManagerWrapper<S>(this.myDelegate.getTaskManager(), this.myProgressManager);
    }

    @Override
    public void applySettings(@NotNull S settings) throws RemoteException {
        this.myDelegate.applySettings(settings);
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager progressManager) throws RemoteException {
        this.myDelegate.applyProgressManager(progressManager);
    }

    @Override
    @NotNull
    public RawExternalSystemProjectResolver<S> getRawProjectResolver() throws RemoteException {
        return this.myDelegate.getRawProjectResolver();
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id2) throws RemoteException {
        return this.myDelegate.isTaskInProgress(id2);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        return this.myDelegate.getTasksInProgress();
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id2) throws RemoteException {
        return this.myDelegate.cancelTask(id2);
    }
}

