/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingExternalSystemAutoImportAware
implements ExternalSystemAutoImportAware {
    @NotNull
    private final ConcurrentMap<String, String> myCache = new ConcurrentHashMap<String, String>();
    @NotNull
    private final ExternalSystemAutoImportAware myDelegate;

    public CachingExternalSystemAutoImportAware(@NotNull ExternalSystemAutoImportAware delegate) {
        this.myDelegate = delegate;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        String cached = (String)this.myCache.get(changedFileOrDirPath);
        if (cached != null) {
            return cached;
        }
        String result2 = this.myDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
        if (result2 != null) {
            this.myCache.put(changedFileOrDirPath, result2);
        }
        return result2;
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        return this.myDelegate.getAffectedExternalProjectFiles(projectPath, project);
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return this.myDelegate.isApplicable(resolverPolicy);
    }
}

