/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Map<ModuleData, Module> myIdeModulesCache = ContainerUtil.createWeakMap();
    private final Map<Module, Map<String, List<ModuleOrderEntry>>> myIdeModuleToModuleDepsCache = ContainerUtil.createWeakMap();

    public IdeModelsProviderImpl(@NotNull Project project) {
        this.myProject = project;
    }

    public Module @NotNull [] getModules() {
        return ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    public Module @NotNull [] getModules(@NotNull ProjectData projectData2) {
        List modules2 = ContainerUtil.filter((Object[])this.getModules(), module -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData2.getOwner(), (Module)module) && StringUtil.equals((CharSequence)projectData2.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)));
        return modules2.toArray(Module.EMPTY_ARRAY);
    }

    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module) {
        return ModuleRootManager.getInstance((Module)module).getOrderEntries();
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module) {
        Module cachedIdeModule = this.myIdeModulesCache.get(module);
        if (cachedIdeModule == null) {
            for (String candidate : this.suggestModuleNameCandidates(module)) {
                Module ideModule = this.findIdeModule(candidate);
                if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module, ideModule)) continue;
                this.myIdeModulesCache.put(module, ideModule);
                return ideModule;
            }
        } else {
            return cachedIdeModule;
        }
        return null;
    }

    protected Iterable<String> suggestModuleNameCandidates(@NotNull ModuleData module) {
        ExternalProjectSettings settings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)module.getOwner()).getLinkedProjectSettings(module.getLinkedExternalProjectPath());
        char delimiter = settings != null && settings.isUseQualifiedModuleNames() ? (char)'.' : '-';
        return new ModuleNameGenerator(module, delimiter).generate();
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)root.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull ModuleData moduleData) {
        for (String moduleName : this.suggestModuleNameCandidates(moduleData)) {
            UnloadedModuleDescription unloadedModuleDescription = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
            if (unloadedModuleDescription == null) continue;
            return unloadedModuleDescription;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module) {
        Map namesToEntries = this.myIdeModuleToModuleDepsCache.computeIfAbsent(module, m -> Arrays.stream(this.getOrderEntries((Module)m)).filter(ModuleOrderEntry.class::isInstance).map(ModuleOrderEntry.class::cast).collect(Collectors.groupingBy(ModuleOrderEntry::getModuleName)));
        List candidates = (List)namesToEntries.get(dependency.getInternalName());
        if (candidates == null) {
            return null;
        }
        for (ModuleOrderEntry candidate : candidates) {
            if (!candidate.getScope().equals((Object)dependency.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data2) {
        Module ownerIdeModule = this.findIdeModule(data2.getOwnerModule());
        if (ownerIdeModule == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data2 instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data2;
        } else if (data2 instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data2;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), PathUtil::getLocalPath);
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data2.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data2.getScope()) continue;
            return entry;
        }
        return null;
    }

    public VirtualFile @NotNull [] getContentRoots(Module module) {
        return ModuleRootManager.getInstance((Module)module).getContentRoots();
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module) {
        return ModuleRootManager.getInstance((Module)module).getSourceRoots();
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module, boolean includingTests) {
        return ModuleRootManager.getInstance((Module)module).getSourceRoots(includingTests);
    }

    public Library @NotNull [] getAllLibraries() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    public String @NotNull [] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        return library.getUrls(type);
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        return ModuleUtilCore.getAllDependentModules((Module)module);
    }

    private static class ModuleNameGenerator {
        private static final int MAX_FILE_DEPTH = 3;
        private static final int MAX_NUMBER_SEQ = 2;
        private final ModuleData myModule;
        private final char myDelimiter;

        ModuleNameGenerator(@NotNull ModuleData module, char delimiter) {
            this.myModule = module;
            this.myDelimiter = delimiter;
        }

        Iterable<String> generate() {
            String prefix = this.myModule.getGroup();
            File modulePath = new File(this.myModule.getLinkedExternalProjectPath());
            if (modulePath.isFile()) {
                modulePath = modulePath.getParentFile();
            }
            final ArrayList names2 = prefix == null || StringUtil.startsWith((CharSequence)this.myModule.getInternalName(), (CharSequence)prefix) ? ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName()}) : ContainerUtil.newArrayList((Object[])new String[]{this.myModule.getInternalName(), prefix + this.myDelimiter + this.myModule.getInternalName()});
            String name = (String)names2.get(0);
            List pathParts = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)modulePath.getPath()));
            StringBuilder nameBuilder = new StringBuilder();
            String duplicateCandidate = name;
            int i2 = pathParts.size() - 1;
            for (int j = 0; i2 >= 0 && j < 3; --i2, ++j) {
                String part = (String)pathParts.get(i2);
                boolean isAlreadyIncluded = false;
                if (!duplicateCandidate.isEmpty()) {
                    if (duplicateCandidate.equals(part) || duplicateCandidate.endsWith(this.myDelimiter + part) || duplicateCandidate.endsWith('_' + part)) {
                        --j;
                        duplicateCandidate = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)duplicateCandidate, (String)part), (char)this.myDelimiter), (char)'_');
                        isAlreadyIncluded = true;
                    } else if (name.startsWith(part) || i2 > 1 && name.startsWith((String)pathParts.get(i2 - 1) + this.myDelimiter + part)) {
                        --j;
                        isAlreadyIncluded = true;
                    } else {
                        duplicateCandidate = "";
                    }
                }
                if (isAlreadyIncluded) continue;
                nameBuilder.insert(0, part + this.myDelimiter);
                names2.add(nameBuilder + name);
            }
            final String namePrefix = (String)ContainerUtil.getLastItem((List)names2);
            return new Iterable<String>(){

                @Override
                @NotNull
                public Iterator<String> iterator() {
                    return ContainerUtil.concatIterators((Iterator[])new Iterator[]{names2.iterator(), new Iterator<String>(){
                        int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < 2;
                        }

                        @Override
                        public String next() {
                            ++this.current;
                            return namePrefix + '~' + this.current;
                        }
                    }});
                }
            };
        }
    }
}

