/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class BuildIssueException
extends ExternalSystemException {
    private final BuildIssue myBuildIssue;

    public BuildIssueException(@NotNull BuildIssue issue) {
        super(issue.getDescription(), BuildIssueException.getQuickfixIds(issue));
        this.myBuildIssue = issue;
    }

    public BuildIssue getBuildIssue() {
        return this.myBuildIssue;
    }

    private static String[] getQuickfixIds(@NotNull BuildIssue issue) {
        return (String[])issue.getQuickFixes().stream().map(fix -> fix.getId()).toArray(String[]::new);
    }
}

