/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.OpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H$J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J$\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0004H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/OpenProjectProvider;", "()V", "canOpenPlatformProject", "", "projectDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "canOpenProject", "file", "focusOnOpenedSameProject", "Ljava/nio/file/Path;", "getProjectDirectory", "isChildExistUsingIo", "parent", "name", "", "isProjectFile", "linkAndRefreshProject", "", "project", "Lcom/intellij/openapi/project/Project;", "linkToExistingProject", "projectFile", "openPlatformProject", "projectToClose", "forceOpenInNewFrame", "openProject", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class AbstractOpenProjectProvider
implements OpenProjectProvider {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    protected abstract boolean isProjectFile(@NotNull VirtualFile var1);

    protected abstract void linkAndRefreshProject(@NotNull Path var1, @NotNull Project var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canOpenProject(@NotNull VirtualFile file2) {
        boolean bl;
        block3: {
            if (file2.isDirectory()) {
                void $this$any$iv;
                VirtualFile[] virtualFileArray = file2.getChildren();
                AbstractOpenProjectProvider abstractOpenProjectProvider = this;
                boolean $i$f$any = false;
                void var5_5 = $this$any$iv;
                int n = ((void)var5_5).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void p1 = element$iv = var5_5[j];
                    boolean bl2 = false;
                    if (!abstractOpenProjectProvider.isProjectFile((VirtualFile)p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = this.isProjectFile(file2);
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        LOG.debug("Open project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        if (this.focusOnOpenedSameProject(projectDirectory.toNioPath())) {
            return null;
        }
        if (this.canOpenPlatformProject(projectDirectory)) {
            return this.openPlatformProject(projectDirectory, projectToClose, forceOpenInNewFrame);
        }
        Path nioPath = projectDirectory.toNioPath();
        Function1 function1 = null;
        Function1 function12 = (Function1)new Function1<Project, Boolean>(this, nioPath){
            final /* synthetic */ AbstractOpenProjectProvider this$0;
            final /* synthetic */ Path $nioPath;

            public final boolean invoke(@NotNull Project project) {
                project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
                ApplicationManager.getApplication().invokeAndWait(new Runnable(this, project){
                    final /* synthetic */ openProject.options.1 this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        this.this$0.this$0.linkAndRefreshProject(this.this$0.$nioPath, this.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                    }
                });
                ProjectUtil.updateLastProjectLocation(this.$nioPath);
                return true;
            }
            {
                this.this$0 = abstractOpenProjectProvider;
                this.$nioPath = path;
                super(1);
            }
        };
        Function1 function13 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        FrameInfo frameInfo = null;
        ProjectOpenedCallback projectOpenedCallback = null;
        boolean bl6 = false;
        String string2 = null;
        Project project = null;
        boolean bl7 = false;
        Project project2 = projectToClose;
        boolean bl8 = forceOpenInNewFrame;
        boolean bl9 = true;
        OpenProjectTask options2 = new OpenProjectTask(bl8, project2, bl9, bl7, project, string2, bl6, projectOpenedCallback, frameInfo, n2, n, bl5, bl4, bl3, string, bl2, bl, function13, function12, function1, 782328, null);
        return ProjectManagerEx.getInstanceEx().openProject(nioPath, options2);
    }

    @Override
    public void linkToExistingProject(@NotNull VirtualFile projectFile, @NotNull Project project) {
        LOG.debug("Import project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        this.linkAndRefreshProject(projectDirectory.toNioPath(), project);
    }

    private final boolean canOpenPlatformProject(VirtualFile projectDirectory) {
        if (!PlatformProjectOpenProcessor.Companion.getInstance().canOpenProject(projectDirectory)) {
            return false;
        }
        if (this.isChildExistUsingIo(projectDirectory, ".idea")) {
            return true;
        }
        return this.isChildExistUsingIo(projectDirectory, projectDirectory.getName() + ".ipr");
    }

    private final boolean isChildExistUsingIo(VirtualFile parent, String name) {
        boolean bl;
        try {
            bl = PathKt.exists((Path)Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), name));
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean focusOnOpenedSameProject(Path projectDirectory) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject(projectDirectory, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return true;
        }
        return false;
    }

    private final Project openPlatformProject(VirtualFile projectDirectory, Project projectToClose, boolean forceOpenInNewFrame) {
        PlatformProjectOpenProcessor openProcessor = PlatformProjectOpenProcessor.Companion.getInstance();
        return openProcessor.doOpenProject(projectDirectory, projectToClose, forceOpenInNewFrame);
    }

    private final VirtualFile getProjectDirectory(VirtualFile file2) {
        return file2.isDirectory() ? file2 : file2.getParent();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(AbstractOpenProjectProvider.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

