/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AssignShortcutAction
extends ExternalSystemNodeAction<TaskData> {
    public AssignShortcutAction() {
        super(TaskData.class);
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return super.isEnabled(e) && !this.isIgnoredNode(e);
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull TaskData taskData, @NotNull AnActionEvent e) {
        ExternalSystemActionsCollector.trigger(project, projectSystemId, this, e);
        ExternalSystemShortcutsManager shortcutsManager = ExternalProjectsManagerImpl.getInstance(project).getShortcutsManager();
        String actionId = shortcutsManager.getActionId(taskData.getLinkedExternalProjectPath(), taskData.getName());
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 == null) {
            String group;
            ExternalSystemNode taskNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)));
            assert (taskNode != null);
            ModuleNode moduleDataNode = taskNode.findParent(ModuleNode.class);
            if (moduleDataNode != null) {
                ModuleData moduleData = (ModuleData)moduleDataNode.getData();
                group = moduleData != null ? moduleData.getInternalName() : null;
            } else {
                ProjectNode projectNode = taskNode.findParent(ProjectNode.class);
                ProjectData projectData2 = projectNode != null ? (ProjectData)projectNode.getData() : null;
                String string = group = projectData2 != null ? projectData2.getInternalName() : null;
            }
            if (group != null) {
                ExternalSystemKeymapExtension.getOrRegisterAction(project, group, taskData);
            }
        }
        new EditKeymapsDialog(project, actionId).show();
    }
}

