/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNodeAction<T>
extends ExternalSystemAction {
    private final Class<T> myExternalDataClazz;

    public ExternalSystemNodeAction(Class<T> externalDataClazz) {
        this.myExternalDataClazz = externalDataClazz;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return super.isEnabled(e) && this.getSystemId(e) != null && this.getExternalData(e, this.myExternalDataClazz) != null;
    }

    protected abstract void perform(@NotNull Project var1, @NotNull ProjectSystemId var2, @NotNull T var3, @NotNull AnActionEvent var4);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = this.getProject(e);
        if (project == null) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        if (projectSystemId == null) {
            return;
        }
        T data2 = this.getExternalData(e, this.myExternalDataClazz);
        if (data2 == null) {
            return;
        }
        ExternalSystemActionsCollector.trigger(project, projectSystemId, this, e);
        this.perform(project, projectSystemId, data2, e);
    }

    @Nullable
    protected ExternalSystemUiAware getExternalSystemUiAware(@NotNull AnActionEvent e) {
        return (ExternalSystemUiAware)e.getData(ExternalSystemDataKeys.UI_AWARE);
    }

    @Nullable
    protected <T> T getExternalData(@NotNull AnActionEvent e, Class<T> dataClass) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)));
        return node != null && dataClass.isInstance(node.getData()) ? (T)node.getData() : null;
    }

    protected boolean isIgnoredNode(@NotNull AnActionEvent e) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)));
        return node != null && this.myExternalDataClazz.isInstance(node.getData()) && node.isIgnored();
    }

    @Nullable
    protected VirtualFile getExternalConfig(@NotNull ExternalConfigPathAware data2, ProjectSystemId externalSystemId) {
        String path = data2.getLinkedExternalProjectPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile externalSystemConfigPath = fileSystem.refreshAndFindFileByPath(path);
        if (externalSystemConfigPath == null) {
            return null;
        }
        VirtualFile toOpen = externalSystemConfigPath;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals((Object)locator.getTargetExternalSystemId())) continue;
            if ((toOpen = locator.adjust(toOpen)) != null) break;
            return null;
        }
        return toOpen.isDirectory() ? null : toOpen;
    }
}

