/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponentImpl;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/EditorFloatingToolbar;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "Companion", "intellij.platform.ide.impl"})
public final class EditorFloatingToolbar
extends JPanel {
    @NotNull
    private static final ExtensionPointName<FloatingToolbarProvider> EP_NAME;
    public static final int ACTION_UPDATE_THROTTLE_DELAY_NS = 500000000;
    public static final Companion Companion;

    public EditorFloatingToolbar(@NotNull EditorImpl editor) {
        this.setLayout(new FlowLayout(2, 20, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        final EditorComponentImpl targetComponent = editor.getContentComponent();
        final JScrollPane container2 = editor.getScrollPane();
        final Disposable parentDisposable = editor.getDisposable();
        final ArrayList toolbarComponents = new ArrayList();
        EP_NAME.forEachExtensionSafe((Consumer)new Consumer<FloatingToolbarProvider>(){

            @Override
            public final void accept(FloatingToolbarProvider provider) {
                ActionGroup actionGroup = provider.getActionGroup();
                boolean autoHideable = provider.getAutoHideable();
                FloatingToolbarComponentImpl component2 = new FloatingToolbarComponentImpl(this, targetComponent, actionGroup, autoHideable, parentDisposable);
                provider.register(component2, parentDisposable);
                toolbarComponents.add(TuplesKt.to((Object)provider, (Object)component2));
            }
        });
        List $this$sortBy$iv = toolbarComponents;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Pair it = (Pair)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(((FloatingToolbarProvider)it.getFirst()).getPriority());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ((FloatingToolbarProvider)it.getFirst()).getPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
        }
        Iterable $this$forEach$iv = toolbarComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.add((Component)it.getSecond());
        }
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(){
            private long lastUpdateTime = Long.MIN_VALUE;

            public final long getLastUpdateTime() {
                return this.lastUpdateTime;
            }

            public final void setLastUpdateTime(long l) {
                this.lastUpdateTime = l;
            }

            /*
             * WARNING - void declaration
             */
            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (!Companion.isInsideActivationArea(container2, e.getMouseEvent().getPoint())) {
                    return;
                }
                for (Pair pair : toolbarComponents) {
                    void provider;
                    FloatingToolbarProvider floatingToolbarProvider = (FloatingToolbarProvider)pair.component1();
                    FloatingToolbarComponentImpl component2 = (FloatingToolbarComponentImpl)pair.component2();
                    if (!provider.getAutoHideable()) continue;
                    long currentTime = System.nanoTime();
                    if (currentTime > this.lastUpdateTime + (long)500000000) {
                        component2.update();
                        this.lastUpdateTime = currentTime;
                    }
                    component2.scheduleShow();
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        EP_NAME = ExtensionPointName.create((String)"com.intellij.editorFloatingToolbarProvider");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/EditorFloatingToolbar$Companion;", "", "()V", "ACTION_UPDATE_THROTTLE_DELAY_NS", "", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "isInsideActivationArea", "", "container", "Ljavax/swing/JScrollPane;", "p", "Ljava/awt/Point;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<FloatingToolbarProvider> getEP_NAME() {
            return EP_NAME;
        }

        private final boolean isInsideActivationArea(JScrollPane container2, Point p) {
            JViewport viewport = container2.getViewport();
            Rectangle r = viewport.getBounds();
            Point viewPosition = viewport.getViewPosition();
            Rectangle activationArea = new Rectangle(0, 0, r.width, r.height);
            return activationArea.contains(p.x, p.y - viewPosition.y);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

