/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Component;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextComponentCaret
extends UserDataHolderBase
implements Caret {
    private final TextComponentEditorImpl myEditor;

    TextComponentCaret(TextComponentEditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    public boolean isValid() {
        return true;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int currentPosition;
        JTextComponent textComponent = this.getTextComponent();
        int targetOffset = Math.min(offset, textComponent.getText().length());
        if (targetOffset != (currentPosition = textComponent.getCaretPosition())) {
            if (targetOffset == textComponent.getCaret().getMark()) {
                textComponent.setCaretPosition(currentPosition);
                textComponent.moveCaretPosition(targetOffset);
            } else {
                textComponent.setCaretPosition(targetOffset);
            }
        }
    }

    public boolean isUpToDate() {
        return true;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        JTextComponent textComponent = this.getTextComponent();
        int caretPos = textComponent.getCaretPosition();
        if (textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)textComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        return new LogicalPosition(line, caretPos - lineStart);
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        return new VisualPosition(pos.line, pos.column);
    }

    public int getOffset() {
        return this.getTextComponent().getCaretPosition();
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public int getSelectionStart() {
        return this.getTextComponent().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        return this.myEditor.offsetToVisualPosition(this.getSelectionStart());
    }

    public int getSelectionEnd() {
        return this.getTextComponent().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        return this.myEditor.offsetToVisualPosition(this.getSelectionEnd());
    }

    @Nullable
    public String getSelectedText() {
        return this.getTextComponent().getSelectedText();
    }

    public int getLeadSelectionOffset() {
        JTextComponent textComponent = this.getTextComponent();
        int caretPosition = textComponent.getCaretPosition();
        int start2 = textComponent.getSelectionStart();
        int end = textComponent.getSelectionEnd();
        return caretPosition == start2 ? end : start2;
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        return this.myEditor.offsetToVisualPosition(this.getLeadSelectionOffset());
    }

    public boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public void setSelection(int startOffset, int endOffset) {
        JTextComponent textComponent = this.getTextComponent();
        if (textComponent.getCaretPosition() == startOffset) {
            textComponent.setCaretPosition(endOffset);
            textComponent.moveCaretPosition(startOffset);
        } else {
            textComponent.setCaretPosition(startOffset);
            textComponent.moveCaretPosition(endOffset);
        }
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void removeSelection() {
        JTextComponent textComponent = this.getTextComponent();
        int position = textComponent.getCaretPosition();
        textComponent.select(position, position);
    }

    public void selectLineAtCaret() {
        SelectionModelImpl.doSelectLineAtCaret(this);
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler2.execute((Editor)this.myEditor, null, DataManager.getInstance().getDataContext((Component)this.myEditor.getComponent()));
    }

    @Nullable
    public Caret clone(boolean above) {
        return null;
    }

    public void dispose() {
    }

    public boolean isAtRtlLocation() {
        return false;
    }

    public boolean isAtBidiRunBoundary() {
        return false;
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        return CaretVisualAttributes.DEFAULT;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
    }

    private JTextComponent getTextComponent() {
        return this.myEditor.getContentComponent();
    }
}

