/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import org.jetbrains.annotations.NotNull;

public class SoftWrapImpl
implements SoftWrap {
    private final TextChangeImpl myChange;
    private final int myIndentInColumns;
    private final int myIndentInPixels;

    public SoftWrapImpl(@NotNull TextChangeImpl change, int indentInColumns, int indentInPixels) {
        this.myChange = change;
        this.myIndentInColumns = indentInColumns;
        this.myIndentInPixels = indentInPixels;
    }

    public int getStart() {
        return this.myChange.getStart();
    }

    public int getEnd() {
        return this.myChange.getEnd();
    }

    @NotNull
    public CharSequence getText() {
        return this.myChange.getText();
    }

    public char @NotNull [] getChars() {
        return this.myChange.getChars();
    }

    public int getIndentInColumns() {
        return this.myIndentInColumns;
    }

    public int getIndentInPixels() {
        return this.myIndentInPixels;
    }

    public TextChangeImpl getChange() {
        return this.myChange;
    }

    public void advance(int diff) {
        this.myChange.advance(diff);
    }

    public int hashCode() {
        int result2 = this.myChange.hashCode();
        result2 = 31 * result2 + this.myIndentInColumns;
        return 31 * result2 + this.myIndentInPixels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftWrapImpl that = (SoftWrapImpl)o;
        return this.myIndentInColumns == that.myIndentInColumns && this.myIndentInPixels == that.myIndentInPixels && this.myChange.equals(that.myChange);
    }

    public String toString() {
        return this.myChange.toString();
    }
}

