/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

final class PersistentRangeMarkerUtil {
    PersistentRangeMarkerUtil() {
    }

    static boolean shouldTranslateViaDiff(@NotNull DocumentEvent e, int rangeStart, int rangeEnd) {
        if (e.isWholeTextReplaced()) {
            return true;
        }
        if (e.getOffset() >= rangeEnd || e.getOffset() + e.getOldLength() <= rangeStart) {
            return false;
        }
        return Math.max(e.getNewLength(), e.getOldLength()) * 5 >= e.getDocument().getTextLength() * 4;
    }
}

