/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.impl.LineIteratorImpl;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class LineSet {
    private static final int MODIFIED_MASK = 4;
    private static final int SEPARATOR_MASK = 3;
    private final int[] myStarts;
    private final byte[] myFlags;
    private final int myLength;

    private LineSet(int[] starts, byte[] flags, int length) {
        this.myStarts = starts;
        this.myFlags = flags;
        this.myLength = length;
    }

    public static LineSet createLineSet(CharSequence text) {
        return LineSet.createLineSet(text, false);
    }

    @NotNull
    private static LineSet createLineSet(@NotNull CharSequence text, boolean markModified) {
        TIntArrayList starts = new TIntArrayList();
        TByteArrayList flags = new TByteArrayList();
        LineTokenizer lineTokenizer = new LineTokenizer(text);
        while (!lineTokenizer.atEnd()) {
            starts.add(lineTokenizer.getOffset());
            flags.add((byte)(lineTokenizer.getLineSeparatorLength() | (markModified ? 4 : 0)));
            lineTokenizer.advance();
        }
        return new LineSet(starts.toNativeArray(), flags.toNativeArray(), text.length());
    }

    @NotNull
    LineSet update(@NotNull CharSequence prevText, int start2, int end, @NotNull CharSequence replacement, boolean wholeTextReplaced) {
        if (this.myLength == 0) {
            return LineSet.createLineSet(replacement, !wholeTextReplaced);
        }
        MergingCharSequence newText = StringUtil.replaceSubSequence((CharSequence)prevText, (int)start2, (int)end, (CharSequence)replacement);
        if (LineSet.hasChar(prevText, start2 - 1, '\r') && (LineSet.hasChar(prevText, start2, '\n') || LineSet.hasChar((CharSequence)newText, start2, '\n'))) {
            replacement = new MergingCharSequence((CharSequence)"\r", replacement);
            --start2;
        }
        if (LineSet.hasChar(prevText, end, '\n') && (LineSet.hasChar(prevText, end - 1, '\r') || LineSet.hasChar((CharSequence)newText, start2 + replacement.length() - 1, '\r'))) {
            replacement = new MergingCharSequence(replacement, (CharSequence)"\n");
            ++end;
        }
        LineSet result2 = this.isSingleLineChange(start2, end, replacement) ? this.updateInsideOneLine(this.findLineIndex(start2), replacement.length() - (end - start2)) : this.genericUpdate(start2, end, replacement);
        return wholeTextReplaced ? result2.clearModificationFlags() : result2;
    }

    private static boolean hasChar(CharSequence s, int index, char c) {
        return index >= 0 && index < s.length() && s.charAt(index) == c;
    }

    private boolean isSingleLineChange(int start2, int end, @NotNull CharSequence replacement) {
        if (start2 == 0 && end == this.myLength && replacement.length() == 0) {
            return false;
        }
        int startLine = this.findLineIndex(start2);
        return startLine == this.findLineIndex(end) && !CharArrayUtil.containLineBreaks((CharSequence)replacement) && !this.isLastEmptyLine(startLine);
    }

    @NotNull
    private LineSet updateInsideOneLine(int line, int lengthDelta) {
        int[] starts = (int[])this.myStarts.clone();
        int i2 = line + 1;
        while (i2 < starts.length) {
            int n = i2++;
            starts[n] = starts[n] + lengthDelta;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int n = line;
        flags[n] = (byte)(flags[n] | 4);
        return new LineSet(starts, flags, this.myLength + lengthDelta);
    }

    private LineSet genericUpdate(int startOffset, int endOffset, CharSequence replacement) {
        int startLine = this.findLineIndex(startOffset);
        int endLine = this.findLineIndex(endOffset);
        LineSet patch = LineSet.createLineSet(replacement, true);
        int lengthShift = patch.myLength - (endOffset - startOffset);
        int startLineStart = this.getLineStart(startLine);
        boolean addStartLine = startOffset - startLineStart > 0 || patch.myStarts.length > 0 || endOffset < this.myLength;
        boolean addEndLine = endOffset < this.myLength && patch.myLength > 0 && patch.getSeparatorLength(patch.myStarts.length - 1) > 0;
        int newLineCount = startLine + (addStartLine ? 1 : 0) + Math.max(patch.myStarts.length - 1, 0) + (addEndLine ? 1 : 0) + Math.max(this.myStarts.length - endLine - 1, 0);
        int[] starts = new int[newLineCount];
        byte[] flags = new byte[newLineCount];
        if (startLine > 0) {
            System.arraycopy(this.myStarts, 0, starts, 0, startLine);
            System.arraycopy(this.myFlags, 0, flags, 0, startLine);
        }
        int toIndex = startLine;
        if (addStartLine) {
            starts[toIndex] = startLineStart;
            flags[toIndex] = patch.myStarts.length > 0 ? patch.myFlags[0] : 4;
            ++toIndex;
        }
        toIndex = patch.shiftData(starts, flags, 1, toIndex, patch.myStarts.length - 1, startOffset);
        if (endOffset < this.myLength) {
            if (addEndLine) {
                starts[toIndex] = endOffset + lengthShift;
                flags[toIndex] = (byte)(this.myFlags[endLine] | 4);
                ++toIndex;
            } else if (toIndex > 0) {
                flags[toIndex - 1] = (byte)(this.myFlags[endLine] | 4);
            }
        }
        this.shiftData(starts, flags, endLine + 1, toIndex, this.myStarts.length - (endLine + 1), lengthShift);
        return new LineSet(starts, flags, this.myLength + lengthShift);
    }

    private int shiftData(int[] dstStarts, byte[] dstFlags, int srcOffset, int dstOffset, int count, int offsetDelta) {
        if (count < 0) {
            return dstOffset;
        }
        System.arraycopy(this.myFlags, srcOffset, dstFlags, dstOffset, count);
        for (int i2 = 0; i2 < count; ++i2) {
            dstStarts[dstOffset + i2] = this.myStarts[srcOffset + i2] + offsetDelta;
        }
        return dstOffset + count;
    }

    public int findLineIndex(int offset) {
        if (offset < 0 || offset > this.myLength) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + this.myLength + "]");
        }
        if (this.myLength == 0) {
            return 0;
        }
        if (offset == this.myLength) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myStarts, offset);
        return bsResult >= 0 ? bsResult : -bsResult - 2;
    }

    @NotNull
    public LineIterator createIterator() {
        return new LineIteratorImpl(this);
    }

    public final int getLineStart(int index) {
        this.checkLineIndex(index);
        return this.isLastEmptyLine(index) ? this.myLength : this.myStarts[index];
    }

    private boolean isLastEmptyLine(int index) {
        return index == this.myFlags.length && this.hasEol(index - 1);
    }

    private boolean hasEol(int lineIndex) {
        return lineIndex >= 0 && this.getSeparatorLengthUnsafe(lineIndex) > 0;
    }

    public final int getLineEnd(int index) {
        this.checkLineIndex(index);
        return index >= this.myStarts.length - 1 ? this.myLength : this.myStarts[index + 1];
    }

    private void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }

    final boolean isModified(int index) {
        this.checkLineIndex(index);
        return !this.isLastEmptyLine(index) && BitUtil.isSet((int)this.myFlags[index], (int)4);
    }

    @NotNull
    final LineSet setModified(@NotNull IntArrayList indices) {
        int index;
        if (indices.isEmpty()) {
            return this;
        }
        if (indices.size() == 1 && (this.isLastEmptyLine(index = indices.getInt(0)) || this.isModified(index))) {
            return this;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            int index2;
            int n = index2 = indices.getInt(i2);
            flags[n] = (byte)(flags[n] | 4);
        }
        return new LineSet(this.myStarts, flags, this.myLength);
    }

    @NotNull
    LineSet clearModificationFlags(int startLine, int endLine) {
        if (startLine > endLine) {
            throw new IllegalArgumentException("endLine < startLine: " + endLine + " < " + startLine + "; lineCount: " + this.getLineCount());
        }
        this.checkLineIndex(startLine);
        this.checkLineIndex(endLine - 1);
        if (this.isLastEmptyLine(endLine - 1)) {
            --endLine;
        }
        if (startLine >= endLine) {
            return this;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int i2 = startLine;
        while (i2 < endLine) {
            int n = i2++;
            flags[n] = (byte)(flags[n] & 0xFFFFFFFB);
        }
        return new LineSet(this.myStarts, flags, this.myLength);
    }

    @NotNull
    LineSet clearModificationFlags() {
        return this.getLineCount() == 0 ? this : this.clearModificationFlags(0, this.getLineCount());
    }

    final int getSeparatorLength(int index) {
        this.checkLineIndex(index);
        return this.getSeparatorLengthUnsafe(index);
    }

    private int getSeparatorLengthUnsafe(int index) {
        return index < this.myFlags.length ? this.myFlags[index] & 3 : 0;
    }

    final int getLineCount() {
        return this.myStarts.length + (this.isLastEmptyLine(this.myStarts.length) ? 1 : 0);
    }

    int getLength() {
        return this.myLength;
    }
}

