/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.SystemInfo;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.util.Collections;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import sun.font.FontDesignMetrics;

public class FontInfo {
    private static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final Font DUMMY_FONT = new Font(null);
    private final Font myFont;
    private final int mySize;
    @JdkConstants.FontStyle
    private final int myStyle;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private final FontRenderContext myContext;
    private FontMetrics myFontMetrics = null;

    @Deprecated
    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style) {
        this(familyName, size, style, false, null);
    }

    @Deprecated
    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures) {
        this(familyName, size, style, useLigatures, null);
    }

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext fontRenderContext) {
        this.mySize = size;
        this.myStyle = style;
        Font font = new Font(familyName, style, size);
        this.myFont = useLigatures ? font.deriveFont(Collections.singletonMap(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON)) : font;
        this.myContext = fontRenderContext;
    }

    public boolean canDisplay(int codePoint) {
        try {
            if (codePoint < 128) {
                return true;
            }
            if (this.mySafeCharacters.contains(codePoint)) {
                return true;
            }
            if (FontInfo.canDisplay(this.myFont, codePoint, false)) {
                this.mySafeCharacters.add(codePoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canDisplay(@NotNull Font font, int codePoint, boolean disableFontFallback) {
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (disableFontFallback && SystemInfo.isMac) {
            int glyphCode = font.createGlyphVector(DEFAULT_CONTEXT, new String(new int[]{codePoint}, 0, 1)).getGlyphCode(0);
            return (glyphCode & 0xFFFFFF) != 0 && (glyphCode & 0xFF000000) == 0;
        }
        return font.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth(metrics, codePoint);
    }

    public float charWidth2D(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth2D(metrics, codePoint);
    }

    public synchronized FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = FontInfo.getFontMetrics(this.myFont, this.myContext == null ? FontInfo.getFontRenderContext(null) : this.myContext);
        }
        return this.myFontMetrics;
    }

    @NotNull
    public static FontMetrics getFontMetrics(@NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        return FontDesignMetrics.getMetrics(font, fontRenderContext);
    }

    public static FontRenderContext getFontRenderContext(Component component2) {
        if (component2 == null) {
            return DEFAULT_CONTEXT;
        }
        return component2.getFontMetrics(DUMMY_FONT).getFontRenderContext();
    }

    public int getSize() {
        return this.mySize;
    }

    @JdkConstants.FontStyle
    public int getStyle() {
        return this.myStyle;
    }

    public FontRenderContext getFontRenderContext() {
        return this.myContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)o;
        return this.myFont.equals(fontInfo.myFont);
    }

    public int hashCode() {
        return this.myFont.hashCode();
    }
}

