/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class FoldingPopupManager
implements EditorMouseListener,
EditorMouseMotionListener {
    private static final Key<Boolean> DISABLED = Key.create((String)"FoldingPopupManager.disabled");
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    private static final int TOOLTIP_DELAY_MS = 300;
    private final Alarm myAlarm;

    public static void disableForEditor(@NotNull Editor editor) {
        editor.putUserData(DISABLED, (Object)Boolean.TRUE);
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, null, true);
    }

    public static void enableForEditor(@NotNull Editor editor) {
        editor.putUserData(DISABLED, null);
    }

    FoldingPopupManager(EditorImpl editor) {
        this.myAlarm = new Alarm(editor.getDisposable());
        editor.addEditorMouseListener(this);
        editor.addEditorMouseMotionListener(this);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        this.myAlarm.cancelAllRequests();
        Editor editor = e.getEditor();
        if (editor.getUserData(DISABLED) != null) {
            return;
        }
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
            MouseEvent mouseEvent = e.getMouseEvent();
            Point point = mouseEvent.getPoint();
            FoldRegion fold = e.getCollapsedFoldRegion();
            TooltipController controller = TooltipController.getInstance();
            if (fold != null && !fold.shouldNeverExpand()) {
                this.myAlarm.addRequest(() -> {
                    if (editor.getUserData(DISABLED) != null || !editor.getComponent().isShowing() || !fold.isValid() || fold.isExpanded()) {
                        return;
                    }
                    DocumentFragment range2 = FoldingPopupManager.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, editor.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip(editor, p, new DocumentFragmentTooltipRenderer(range2), false, FOLDING_TOOLTIP_GROUP);
                }, 300);
            } else {
                controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, mouseEvent, true);
            }
        }
    }

    @NotNull
    private static DocumentFragment createDocumentFragment(@NotNull FoldRegion fold) {
        int groupEndOffset;
        EditorImpl editor = (EditorImpl)fold.getEditor();
        DocumentEx document = editor.getDocument();
        FoldingGroup group = fold.getGroup();
        int startOffset = fold.getStartOffset();
        int endOffset = fold.getEndOffset();
        if (group != null && editor.offsetToVisualLine(groupEndOffset = editor.getFoldingModel().getEndOffset(group)) == editor.offsetToVisualLine(startOffset)) {
            endOffset = groupEndOffset;
        }
        return new DocumentFragment((Document)document, startOffset, endOffset);
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        this.myAlarm.cancelAllRequests();
        if (e.getEditor().getUserData(DISABLED) != null) {
            return;
        }
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e.getMouseEvent(), true);
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
    }

    public void mouseEntered(@NotNull EditorMouseEvent e) {
    }
}

