/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.MarkupIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class FilteringMarkupIterator<T>
implements MarkupIterator<T> {
    @NotNull
    private final MarkupIterator<T> myDelegate;
    @NotNull
    private final Predicate<? super T> myFilter;

    public FilteringMarkupIterator(@NotNull MarkupIterator<T> delegate, @NotNull Predicate<? super T> filter2) {
        this.myDelegate = delegate;
        this.myFilter = filter2;
        this.skipUnrelated();
    }

    @Override
    public void dispose() {
        this.myDelegate.dispose();
    }

    public T peek() throws NoSuchElementException {
        return (T)this.myDelegate.peek();
    }

    public boolean hasNext() {
        return this.myDelegate.hasNext();
    }

    public T next() {
        Object result2 = this.myDelegate.next();
        this.skipUnrelated();
        return (T)result2;
    }

    private void skipUnrelated() {
        while (this.myDelegate.hasNext() && !this.myFilter.test(this.myDelegate.peek())) {
            this.myDelegate.next();
        }
    }
}

