/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

@Service
public final class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");
    private final Collection<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public static EditorMouseHoverPopupControl getInstance() {
        return (EditorMouseHoverPopupControl)ApplicationManager.getApplication().getService(EditorMouseHoverPopupControl.class);
    }

    public static void disablePopups(@NotNull Editor editor) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor, true);
    }

    public static void enablePopups(@NotNull Editor editor) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)editor, false);
    }

    public static void disablePopups(@NotNull Document document) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, true);
    }

    public static void enablePopups(@NotNull Document document) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)document, false);
    }

    public static void disablePopups(@NotNull Project project) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project, true);
    }

    public static void enablePopups(@NotNull Project project) {
        EditorMouseHoverPopupControl.setTrackingDisabled((UserDataHolder)project, false);
    }

    private static void setTrackingDisabled(@NotNull UserDataHolder holder, boolean value2) {
        EditorMouseHoverPopupControl instance;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Integer userData = (Integer)holder.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value2 ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        holder.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
        if (userData == null != (count == 0) && (instance = EditorMouseHoverPopupControl.getInstance()) != null) {
            instance.listeners.forEach(Runnable::run);
        }
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = editor.getProject();
        return editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor.getDocument().getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || project != null && project.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null;
    }

    public void addListener(@NotNull Runnable listener2) {
        this.listeners.add(listener2);
    }
}

