/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;

public class EditorActionManagerImpl
extends EditorActionManager {
    private ReadonlyFragmentModificationHandler myReadonlyFragmentsHandler = new DefaultReadOnlyFragmentModificationHandler();

    public EditorActionHandler getActionHandler(@NotNull String actionId) {
        return ((EditorAction)ActionManager.getInstance().getAction(actionId)).getHandler();
    }

    public EditorActionHandler setActionHandler(@NotNull String actionId, @NotNull EditorActionHandler handler2) {
        EditorAction action2 = (EditorAction)ActionManager.getInstance().getAction(actionId);
        return action2.setupHandler(handler2);
    }

    @NotNull
    public TypedAction getTypedAction() {
        return TypedAction.getInstance();
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentsHandler;
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler(@NotNull Document document) {
        Document doc = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        ReadonlyFragmentModificationHandler docHandler = doc instanceof DocumentImpl ? ((DocumentImpl)doc).getReadonlyFragmentModificationHandler() : null;
        return docHandler == null ? this.myReadonlyFragmentsHandler : docHandler;
    }

    public void setReadonlyFragmentModificationHandler(@NotNull Document document, ReadonlyFragmentModificationHandler handler2) {
        Document doc;
        Document document2 = doc = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        if (doc instanceof DocumentImpl) {
            ((DocumentImpl)document).setReadonlyFragmentModificationHandler(handler2);
        }
    }

    public ReadonlyFragmentModificationHandler setReadonlyFragmentModificationHandler(@NotNull ReadonlyFragmentModificationHandler handler2) {
        ReadonlyFragmentModificationHandler oldHandler = this.myReadonlyFragmentsHandler;
        this.myReadonlyFragmentsHandler = handler2;
        return oldHandler;
    }

    private static class DefaultReadOnlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private DefaultReadOnlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
            Messages.showErrorDialog((String)EditorBundle.message((String)"guarded.block.modification.attempt.error.message", (Object[])new Object[0]), (String)EditorBundle.message((String)"guarded.block.modification.attempt.error.title", (Object[])new Object[0]));
        }
    }
}

