/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    public static MarkupModel forDocument(@NotNull Document document, @Nullable Project project, boolean create2) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document instanceof DocumentWindow) {
            Document delegate = ((DocumentWindow)document).getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate, project, true);
            return new MarkupModelWindow(baseMarkupModel, (DocumentWindow)document);
        }
        if (project == null) {
            MarkupModelImpl newModel;
            MarkupModelEx markupModel = (MarkupModelEx)document.getUserData(MARKUP_MODEL_KEY);
            if (create2 && markupModel == null && (markupModel = (MarkupModelEx)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)(newModel = new MarkupModelImpl((DocumentEx)document)))) != newModel) {
                newModel.dispose();
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project.isDisposed()) {
            return new EmptyMarkupModel(document);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document);
        MarkupModelImpl model = (MarkupModelImpl)markupModelMap.get(project);
        if (create2 && model == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
            model = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project, (Object)newModel);
            if (model == newModel) {
                documentMarkupModelManager.registerDocument(document);
            } else {
                newModel.dispose();
            }
        }
        return model;
    }

    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document) {
        ConcurrentMap markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY);
        if (markupModelMap == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, newMap);
        }
        return markupModelMap;
    }

    static void removeMarkupModel(@NotNull Document document, @NotNull Project project) {
        MarkupModelImpl removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document).remove(project);
        if (removed != null) {
            removed.dispose();
        }
    }
}

