/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Flip ','";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement comma = FlipCommaIntention.currentCommaElement(editor, file2);
        if (comma == null) {
            return false;
        }
        PsiElement left = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement right = FlipCommaIntention.smartAdvance(comma, true);
        return left != null && right != null && !left.getText().equals(right.getText()) && Flipper.isCanFlip(left, right);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2 = FlipCommaIntention.currentCommaElement(editor, file2);
        if (element2 != null) {
            FlipCommaIntention.swapAtComma(element2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        PsiElement prev = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev != null && next != null) {
            if (Flipper.tryFlip(prev, next)) {
                return;
            }
            FlipCommaIntention.swapViaDocument(comma, prev, next);
        }
    }

    private static void swapViaDocument(@NotNull PsiElement comma, PsiElement prev, PsiElement next) {
        DocumentEx document = (DocumentEx)comma.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        String prevText = prev.getText();
        String nextText = next.getText();
        TextRange prevRange = prev.getTextRange();
        TextRange nextRange = next.getTextRange();
        document.replaceString(prevRange.getStartOffset(), prevRange.getEndOffset(), nextText);
        nextRange = nextRange.shiftRight(nextText.length() - prevText.length());
        document.replaceString(nextRange.getStartOffset(), nextRange.getEndOffset(), prevText);
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2 = FlipCommaIntention.leftElement(editor, file2);
        if (!FlipCommaIntention.isComma(element2) && !FlipCommaIntention.isComma(element2 = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element2;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element2) {
        return element2 != null && element2.textMatches((CharSequence)",");
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblings(PsiElement element2, boolean fwd) {
        SyntaxTraverser.ApiEx api = fwd ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        JBIterable flatSiblings = JBIterable.generate((Object)element2, arg_0 -> ((SyntaxTraverser.ApiEx)api).next(arg_0)).skip(1);
        return ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)api).withRoots((Iterable)flatSiblings)).expandAndSkip(e -> api.typeOf(e) == GeneratedParserUtilBase.DUMMY_BLOCK)).traverse();
    }

    private static boolean isFlippable(PsiElement e) {
        if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
            return false;
        }
        return StringUtil.isNotEmpty((String)e.getText());
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element2, boolean fwd) {
        PsiElement candidate = (PsiElement)FlipCommaIntention.getSiblings(element2, fwd).filter(e -> FlipCommaIntention.isFlippable(e)).first();
        if (candidate != null && FlipCommaIntention.isBrace(candidate)) {
            return null;
        }
        return candidate;
    }

    private static boolean isBrace(@NotNull PsiElement candidate) {
        PairedBraceMatcher braceMatcher;
        ASTNode node = candidate.getNode();
        if (node != null && node.getFirstChildNode() == null && (braceMatcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(candidate.getLanguage())) != null) {
            IElementType elementType = node.getElementType();
            for (BracePair pair : braceMatcher.getPairs()) {
                if (elementType != pair.getLeftBraceType() && elementType != pair.getRightBraceType()) continue;
                return true;
            }
        }
        return false;
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(@NotNull PsiElement var1, @NotNull PsiElement var2);

        default public boolean canFlip(@NotNull PsiElement left, @NotNull PsiElement right) {
            return true;
        }

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }

        public static boolean isCanFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (handler2.canFlip(left, right)) continue;
                return false;
            }
            return true;
        }
    }
}

