/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.LanguageWordBoundaryFilter;
import com.intellij.openapi.editor.actions.WordBoundaryFilter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorActionUtil {
    protected static final Object EDIT_COMMAND_GROUP = Key.create((String)"EditGroup");
    public static final Object DELETE_COMMAND_GROUP = Key.create((String)"DeleteGroup");
    private static final Key<VisualPosition> PREV_POS = Key.create((String)"PREV_POS");

    private EditorActionUtil() {
    }

    public static void scrollRelatively(@NotNull Editor editor, int lineShift, int columnShift, boolean moveCaret) {
        if (lineShift != 0) {
            editor.getScrollingModel().scrollVertically(editor.getScrollingModel().getVerticalScrollOffset() + lineShift * editor.getLineHeight());
        }
        if (columnShift != 0) {
            editor.getScrollingModel().scrollHorizontally(editor.getScrollingModel().getHorizontalScrollOffset() + columnShift * EditorUtil.getSpaceWidth(0, editor));
        }
        if (!moveCaret) {
            return;
        }
        Rectangle viewRectangle = EditorActionUtil.getVisibleArea(editor);
        int lineNumber = editor.getCaretModel().getVisualPosition().line;
        VisualPosition startPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y));
        int start2 = startPos.line + 1;
        VisualPosition endPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y + viewRectangle.height));
        int end = endPos.line - 2;
        if (lineNumber < start2) {
            editor.getCaretModel().moveCaretRelatively(0, start2 - lineNumber, false, false, true);
        } else if (lineNumber > end) {
            editor.getCaretModel().moveCaretRelatively(0, end - lineNumber, false, false, true);
        }
    }

    public static void moveCaretRelativelyAndScroll(@NotNull Editor editor, int columnShift, int lineShift, boolean withSelection) {
        boolean scrollToCaret;
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Point caretLocation = editor.visualPositionToXY(pos);
        int caretVShift = caretLocation.y - visibleArea.y;
        editor.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, false);
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Point caretLocation2 = editor.visualPositionToXY(caretPos);
        boolean bl = scrollToCaret = !(editor instanceof EditorImpl) || ((EditorImpl)editor).isScrollToCaret();
        if (scrollToCaret) {
            editor.getScrollingModel().scrollVertically(caretLocation2.y - caretVShift);
        }
    }

    public static void indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent) {
        int caretOffset = editor.getCaretModel().getOffset();
        int newCaretOffset = EditorActionUtil.indentLine(project, editor, lineNumber, indent, caretOffset);
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        return EditorCoreUtil.indentLine((Project)project, (Editor)editor, (int)lineNumber, (int)indent, (int)caretOffset, (boolean)EditorActionUtil.shouldUseSmartTabs(project, editor));
    }

    public static boolean shouldUseSmartTabs(Project project, @NotNull Editor editor) {
        if (!(editor instanceof EditorEx)) {
            return false;
        }
        return CodeStyle.getIndentOptions((Project)project, (Document)editor.getDocument()).SMART_TABS;
    }

    @NotNull
    public static TextRange getRangeToWordEnd(@NotNull Editor editor, boolean isCamel, boolean handleQuoted) {
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = EditorActionUtil.getNextCaretStopOffset(editor, CaretStopPolicy.BOTH, isCamel, handleQuoted);
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    @NotNull
    public static TextRange getRangeToWordStart(@NotNull Editor editor, boolean isCamel, boolean handleQuoted) {
        int endOffset = editor.getCaretModel().getOffset();
        int startOffset = EditorActionUtil.getPreviousCaretStopOffset(editor, CaretStopPolicy.WORD_START, isCamel, handleQuoted);
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    public static int getNextCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        return EditorActionUtil.getNextCaretStopOffset(editor, caretStopPolicy, isCamel, false);
    }

    public static int getPreviousCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        return EditorActionUtil.getPreviousCaretStopOffset(editor, caretStopPolicy, isCamel, false);
    }

    public static int getNextCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetBeforeQuote;
        HighlighterIterator tokenIterator;
        int maxOffset = EditorActionUtil.getNextLineStopOffset(editor, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals(CaretStop.NONE)) {
            return maxOffset;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == maxOffset) {
            return maxOffset;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getNextWordStopOffset(text, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor, offset), offset, maxOffset, isCamel);
        if (newOffset < maxOffset && handleQuoted && tokenIterator != null && EditorActionUtil.isTokenStart(tokenIterator, newOffset - 1) && EditorActionUtil.isQuotedToken(tokenIterator, text) && EditorActionUtil.isTokenEnd(tokenIterator, (newOffsetBeforeQuote = EditorActionUtil.getNextWordStopOffset(text, CaretStop.BOTH, tokenIterator, newOffset, maxOffset, isCamel)) + 1)) {
            return EditorActionUtil.getNextWordStopOffset(text, wordStop, tokenIterator, newOffsetBeforeQuote, maxOffset, isCamel);
        }
        return newOffset;
    }

    public static int getPreviousCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetAfterQuote;
        HighlighterIterator tokenIterator;
        int minOffset = EditorActionUtil.getPreviousLineStopOffset(editor, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals(CaretStop.NONE)) {
            return minOffset;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == minOffset) {
            return minOffset;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getPreviousWordStopOffset(text, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor, offset - 1), offset, minOffset, isCamel);
        if (newOffset > minOffset && handleQuoted && tokenIterator != null && EditorActionUtil.isTokenEnd(tokenIterator, newOffset + 1) && EditorActionUtil.isQuotedToken(tokenIterator, text) && EditorActionUtil.isTokenStart(tokenIterator, (newOffsetAfterQuote = EditorActionUtil.getPreviousWordStopOffset(text, CaretStop.BOTH, tokenIterator, newOffset, minOffset, isCamel)) - 1)) {
            return EditorActionUtil.getPreviousWordStopOffset(text, wordStop, tokenIterator, newOffsetAfterQuote, minOffset, isCamel);
        }
        return newOffset;
    }

    private static int getNextWordStopOffset(@NotNull CharSequence text, @NotNull CaretStop wordStop, @Nullable HighlighterIterator tokenIterator, int offset, int maxOffset, boolean isCamel) {
        int newOffset;
        for (newOffset = offset + 1; newOffset < maxOffset; ++newOffset) {
            boolean isTokenBoundary;
            boolean bl = isTokenBoundary = tokenIterator != null && EditorActionUtil.advanceTokenOnBoundary(tokenIterator, text, newOffset);
            if (EditorActionUtil.isWordStopOffset(text, wordStop, newOffset, isCamel, isTokenBoundary)) break;
        }
        return newOffset;
    }

    private static int getPreviousWordStopOffset(@NotNull CharSequence text, @NotNull CaretStop wordStop, @Nullable HighlighterIterator tokenIterator, int offset, int minOffset, boolean isCamel) {
        int newOffset;
        for (newOffset = offset - 1; newOffset > minOffset; --newOffset) {
            boolean isTokenBoundary;
            boolean bl = isTokenBoundary = tokenIterator != null && EditorActionUtil.retreatTokenOnBoundary(tokenIterator, text, newOffset);
            if (EditorActionUtil.isWordStopOffset(text, wordStop, newOffset, isCamel, isTokenBoundary)) break;
        }
        return newOffset;
    }

    private static boolean isWordStopOffset(@NotNull CharSequence text, @NotNull CaretStop wordStop, int offset, boolean isCamel, boolean isLexemeBoundary) {
        if (wordStop.isAtStart() && wordStop.isAtEnd()) {
            return isLexemeBoundary || EditorActionUtil.isWordStart(text, offset, isCamel) || EditorActionUtil.isWordEnd(text, offset, isCamel);
        }
        if (wordStop.isAtStart()) {
            return isLexemeBoundary && !EditorActionUtil.isWordEnd(text, offset, isCamel) || EditorActionUtil.isWordStart(text, offset, isCamel);
        }
        if (wordStop.isAtEnd()) {
            return isLexemeBoundary && !EditorActionUtil.isWordStart(text, offset, isCamel) || EditorActionUtil.isWordEnd(text, offset, isCamel);
        }
        return false;
    }

    private static boolean advanceTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text, int offset) {
        if (EditorActionUtil.isTokenEnd(tokenIterator, offset)) {
            IElementType leftToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text);
            tokenIterator.advance();
            return wasQuotedToken || EditorActionUtil.isQuotedToken(tokenIterator, text) || !EditorActionUtil.isBetweenWhitespaces(text, offset) && EditorActionUtil.isLexemeBoundary(leftToken, tokenIterator.getTokenType());
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text, offset);
    }

    private static boolean retreatTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text, int offset) {
        if (EditorActionUtil.isTokenStart(tokenIterator, offset)) {
            IElementType rightToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text);
            tokenIterator.retreat();
            return wasQuotedToken || EditorActionUtil.isQuotedToken(tokenIterator, text) || !EditorActionUtil.isBetweenWhitespaces(text, offset) && EditorActionUtil.isLexemeBoundary(tokenIterator.getTokenType(), rightToken);
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text, offset);
    }

    private static boolean isQuotedTokenInnardsBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text, int offset) {
        return (EditorActionUtil.isTokenStart(tokenIterator, offset - 1) || EditorActionUtil.isTokenEnd(tokenIterator, offset + 1)) && EditorActionUtil.isQuotedToken(tokenIterator, text);
    }

    private static boolean isTokenStart(@NotNull HighlighterIterator tokenIterator, int offset) {
        return offset == tokenIterator.getStart();
    }

    private static boolean isTokenEnd(@NotNull HighlighterIterator tokenIterator, int offset) {
        return offset == tokenIterator.getEnd();
    }

    private static boolean isQuotedToken(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text) {
        int startOffset = tokenIterator.getStart();
        int endOffset = tokenIterator.getEnd();
        if (endOffset - startOffset < 2) {
            return false;
        }
        char openingQuote = EditorActionUtil.getQuoteAt(text, startOffset);
        char closingQuote = EditorActionUtil.getQuoteAt(text, endOffset - 1);
        return openingQuote != '\u0000' && closingQuote == openingQuote;
    }

    private static char getQuoteAt(@NotNull CharSequence text, int offset) {
        if (offset < 0 || offset >= text.length()) {
            return '\u0000';
        }
        char ch = text.charAt(offset);
        return ch == '\'' || ch == '\"' ? ch : (char)'\u0000';
    }

    @Nullable
    private static HighlighterIterator createHighlighterIteratorAtOffset(@NotNull Editor editor, int offset) {
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        return ((EditorEx)editor).getHighlighter().createIterator(offset);
    }

    private static boolean isLexemeBoundary(@Nullable IElementType leftTokenType, @Nullable IElementType rightTokenType) {
        return leftTokenType != null && rightTokenType != null && ((WordBoundaryFilter)LanguageWordBoundaryFilter.INSTANCE.forLanguage(rightTokenType.getLanguage())).isWordBoundary(leftTokenType, rightTokenType);
    }

    public static int getNextLineStopOffset(@NotNull Editor editor, @NotNull CaretStop lineStop) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineEnd = caretModel.getOffset() == document.getLineEndOffset(lineNumber);
        return EditorActionUtil.getNextLineStopOffset(document, lineStop, lineNumber, isAtLineEnd);
    }

    private static int getNextLineStopOffset(@NotNull Document document, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineEnd) {
        if (lineNumber + 1 >= document.getLineCount()) {
            return document.getTextLength();
        }
        if (!isAtLineEnd) {
            return lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber) : (lineStop.isAtStart() ? document.getLineStartOffset(lineNumber + 1) : document.getTextLength());
        }
        return lineStop.isAtStart() ? document.getLineStartOffset(lineNumber + 1) : (lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber + 1) : document.getTextLength());
    }

    public static int getPreviousLineStopOffset(@NotNull Editor editor, @NotNull CaretStop lineStop) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineStart = caretModel.getOffset() == document.getLineStartOffset(lineNumber);
        return EditorActionUtil.getPreviousLineStopOffset(document, lineStop, lineNumber, isAtLineStart);
    }

    private static int getPreviousLineStopOffset(@NotNull Document document, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineStart) {
        if (lineNumber - 1 < 0) {
            return 0;
        }
        if (!isAtLineStart) {
            return lineStop.isAtStart() ? document.getLineStartOffset(lineNumber) : (lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber - 1) : 0);
        }
        return lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber - 1) : (lineStop.isAtStart() ? document.getLineStartOffset(lineNumber - 1) : 0);
    }

    public static boolean isWordOrLexemeStart(@NotNull Editor editor, int offset, boolean isCamel) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        return EditorActionUtil.isWordStart(chars, offset, isCamel) || !EditorActionUtil.isWordEnd(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isWordOrLexemeEnd(@NotNull Editor editor, int offset, boolean isCamel) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        return EditorActionUtil.isWordEnd(chars, offset, isCamel) || !EditorActionUtil.isWordStart(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isLexemeBoundary(@NotNull Editor editor, int offset) {
        if (!(editor instanceof EditorEx) || offset <= 0 || offset >= editor.getDocument().getTextLength() || DocumentUtil.isInsideSurrogatePair(editor.getDocument(), offset) || EditorActionUtil.isBetweenWhitespaces(editor.getDocument().getCharsSequence(), offset)) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator it = highlighter.createIterator(offset);
        return EditorActionUtil.retreatTokenOnBoundary(it, editor.getDocument().getCharsSequence(), offset);
    }

    public static void moveCaretToLineStart(@NotNull Editor editor, boolean isWithSelection) {
        int logLineToUse;
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        EditorSettings editorSettings = editor.getSettings();
        int logCaretLine = caretModel.getLogicalPosition().line;
        VisualPosition currentVisCaret = caretModel.getVisualPosition();
        VisualPosition caretLogLineStartVis = editor.offsetToVisualPosition(document.getLineStartOffset(logCaretLine));
        if (currentVisCaret.line > caretLogLineStartVis.line) {
            if (editorSettings.isSmartHome()) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, currentVisCaret);
            } else {
                caretModel.moveToVisualPosition(new VisualPosition(currentVisCaret.line, 0));
            }
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        for (logLineToUse = logCaretLine - 1; logLineToUse >= 0 && editor.offsetToVisualPosition((int)document.getLineEndOffset((int)logLineToUse)).line == currentVisCaret.line; --logLineToUse) {
        }
        if (++logLineToUse >= document.getLineCount() || !editorSettings.isSmartHome()) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logLineToUse, 0));
        } else if (logLineToUse == logCaretLine) {
            int column;
            int line = currentVisCaret.line;
            if (currentVisCaret.column == 0) {
                column = EditorActionUtil.findSmartIndentColumn(editor, currentVisCaret.line);
            } else {
                column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisCaret.line);
                if (column >= currentVisCaret.column) {
                    column = 0;
                }
            }
            caretModel.moveToVisualPosition(new VisualPosition(line, Math.max(column, 0)));
        } else {
            LogicalPosition logLineEndLog = editor.offsetToLogicalPosition(document.getLineEndOffset(logLineToUse));
            VisualPosition logLineEndVis = editor.logicalToVisualPosition(logLineEndLog);
            int softWrapCount = EditorUtil.getSoftWrapCountAfterLineStart(editor, logLineEndLog);
            if (softWrapCount > 0) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, logLineEndVis);
            } else {
                int firstNonSpaceColumnOnTheLine;
                int line = logLineEndVis.line;
                int column = 0;
                if (currentVisCaret.column > 0 && (firstNonSpaceColumnOnTheLine = Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisCaret.line))) < currentVisCaret.column) {
                    column = firstNonSpaceColumnOnTheLine;
                }
                caretModel.moveToVisualPosition(new VisualPosition(line, column));
            }
        }
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static void moveCaretToStartOfSoftWrappedLine(@NotNull Editor editor, VisualPosition currentVisual) {
        CaretModel caretModel = editor.getCaretModel();
        int startLineOffset = editor.visualPositionToOffset(new VisualPosition(currentVisual.line, 0));
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(startLineOffset);
        if (softWrap == null) {
            int column;
            int columnToMove = column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisual.line);
            if (column < 0 || currentVisual.column <= column && currentVisual.column > 0) {
                columnToMove = 0;
            }
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, columnToMove));
            return;
        }
        if (currentVisual.column > softWrap.getIndentInColumns()) {
            caretModel.moveToOffset(softWrap.getStart());
        } else if (currentVisual.column > 0) {
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, 0));
        } else {
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, startLineOffset);
            int visualLine = editor.offsetToVisualPosition((int)lineStartOffset).line;
            caretModel.moveToVisualPosition(new VisualPosition(visualLine, Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, visualLine))));
        }
    }

    private static int findSmartIndentColumn(@NotNull Editor editor, int visualLine) {
        for (int i2 = visualLine; i2 >= 0; --i2) {
            int column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, i2);
            if (column < 0) continue;
            return column;
        }
        return 0;
    }

    public static int findFirstNonSpaceColumnOnTheLine(@NotNull Editor editor, int visualLineNumber) {
        int startOffset = editor.visualPositionToOffset(new VisualPosition(visualLineNumber, 0));
        int endOffset = EditorUtil.getNotFoldedLineEndOffset(editor, startOffset);
        int offset = EditorActionUtil.findFirstNonSpaceOffsetInRange(editor.getDocument().getImmutableCharSequence(), startOffset, endOffset);
        if (offset == -1) {
            return -1;
        }
        VisualPosition targetPosition = editor.offsetToVisualPosition(offset, true, false);
        return targetPosition.line == visualLineNumber ? targetPosition.column : -1;
    }

    public static int findFirstNonSpaceOffsetOnTheLine(@NotNull Document document, int lineNumber) {
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int result2 = EditorActionUtil.findFirstNonSpaceOffsetInRange(document.getCharsSequence(), lineStart, lineEnd);
        return result2 >= 0 ? result2 : lineEnd;
    }

    public static int findFirstNonSpaceOffsetInRange(@NotNull CharSequence text, int start2, int end) {
        while (start2 < end) {
            char c = text.charAt(start2);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return start2;
            }
            ++start2;
        }
        return -1;
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor, boolean isWithSelection) {
        EditorActionUtil.moveCaretToLineEnd(editor, isWithSelection, true);
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor, boolean isWithSelection, boolean ignoreTrailingWhitespace) {
        int offset;
        VisualPosition visualEndOfLineWithCaret;
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        VisualPosition currentVisualCaret = editor.getCaretModel().getVisualPosition();
        if (currentVisualCaret.equals((Object)(visualEndOfLineWithCaret = new VisualPosition(currentVisualCaret.line, EditorUtil.getLastVisualLineColumnNumber(editor, currentVisualCaret.line), true))) && (offset = editor.visualPositionToOffset(visualEndOfLineWithCaret)) < editor.getDocument().getTextLength()) {
            int logicalLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor, offset);
            visualEndOfLineWithCaret = editor.offsetToVisualPosition(logicalLineEndOffset, true, false);
        }
        LogicalPosition logLineEnd = editor.visualToLogicalPosition(visualEndOfLineWithCaret);
        int offset2 = editor.logicalPositionToOffset(logLineEnd);
        lineNumber = logLineEnd.line;
        int newOffset = offset2;
        CharSequence text = document.getCharsSequence();
        int i2 = newOffset - 1;
        while (i2 >= document.getLineStartOffset(lineNumber)) {
            if (softWrapModel.getSoftWrap(i2) != null) {
                newOffset = offset2;
                break;
            }
            if (text.charAt(i2) != ' ' && text.charAt(i2) != '\t') break;
            newOffset = i2--;
        }
        if (newOffset == offset2 || newOffset == caretModel.getOffset() || !ignoreTrailingWhitespace) {
            caretModel.moveToVisualPosition(visualEndOfLineWithCaret);
        } else if (editor instanceof EditorImpl) {
            caretModel.moveToLogicalPosition(editor.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            caretModel.moveToOffset(newOffset);
        }
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretToNextWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        EditorActionUtil.moveToNextCaretStop(editor, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getForwardPolicy(), isWithSelection, camel);
    }

    public static void moveToNextCaretStop(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int boundaryOffset;
        int newOffset;
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = caretModel.getOffset();
        if (offset == document.getTextLength()) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getEndOffset();
        } else {
            newOffset = EditorActionUtil.getNextCaretStopOffset(editor, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null) {
                newOffset = foldRegion.getStartOffset();
            }
        }
        if (editor instanceof EditorImpl && (boundaryOffset = ((EditorImpl)editor).findNearestDirectionBoundary(offset, true)) >= 0) {
            newOffset = Math.min(boundaryOffset, newOffset);
        }
        caretModel.moveToOffset(newOffset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static void setupSelection(@NotNull Editor editor, boolean isWithSelection, int selectionStart, @NotNull LogicalPosition blockSelectionStart) {
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (isWithSelection) {
            if (editor.isColumnMode() && !caretModel.supportsMultipleCarets()) {
                selectionModel.setBlockSelection(blockSelectionStart, caretModel.getLogicalPosition());
            } else {
                selectionModel.setSelection(selectionStart, caretModel.getVisualPosition(), caretModel.getOffset());
            }
        } else {
            selectionModel.removeSelection();
        }
        EditorActionUtil.selectNonexpandableFold(editor);
    }

    public static void selectNonexpandableFold(@NotNull Editor editor) {
        CaretModel caretModel = editor.getCaretModel();
        VisualPosition pos = caretModel.getVisualPosition();
        VisualPosition prevPos = (VisualPosition)editor.getUserData(PREV_POS);
        if (prevPos != null) {
            int columnShift = pos.line == prevPos.line ? pos.column - prevPos.column : 0;
            int caret = caretModel.getOffset();
            FoldRegion collapsedUnderCaret = editor.getFoldingModel().getCollapsedRegionAtOffset(caret);
            if (collapsedUnderCaret != null && collapsedUnderCaret.shouldNeverExpand() && Boolean.TRUE.equals(collapsedUnderCaret.getUserData(FoldingModelImpl.SELECT_REGION_ON_CARET_NEARBY))) {
                if (caret > collapsedUnderCaret.getStartOffset() && columnShift > 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getEndOffset());
                } else if (caret + 1 < collapsedUnderCaret.getEndOffset() && columnShift < 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getStartOffset());
                }
                editor.getSelectionModel().setSelection(collapsedUnderCaret.getStartOffset(), collapsedUnderCaret.getEndOffset());
            }
        }
        editor.putUserData(PREV_POS, (Object)pos);
    }

    public static void moveCaretToPreviousWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        EditorActionUtil.moveToPreviousCaretStop(editor, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getBackwardPolicy(), isWithSelection, camel);
    }

    public static void moveToPreviousCaretStop(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int newOffset;
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getStartOffset();
        } else {
            newOffset = EditorActionUtil.getPreviousCaretStopOffset(editor, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null && newOffset > foldRegion.getStartOffset()) {
                newOffset = foldRegion.getEndOffset();
            }
        }
        if (editor instanceof EditorImpl) {
            int boundaryOffset = ((EditorImpl)editor).findNearestDirectionBoundary(offset, false);
            if (boundaryOffset >= 0) {
                newOffset = Math.max(boundaryOffset, newOffset);
            }
            caretModel.moveToLogicalPosition(editor.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            editor.getCaretModel().moveToOffset(newOffset);
        }
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageUp(@NotNull Editor editor, boolean isWithSelection) {
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        editor.getScrollingModel().scrollVertically(EditorActionUtil.adjustYToVisualLineBase(editor, visibleArea.y - visibleArea.height / lineHeight * lineHeight));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor, editor.getCaretModel().getVisualPosition().line, -visibleArea.height);
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageDown(@NotNull Editor editor, boolean isWithSelection) {
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int allowedBottom = ((EditorEx)editor).getContentSize().height - visibleArea.height;
        editor.getScrollingModel().scrollVertically(Math.min(allowedBottom, EditorActionUtil.adjustYToVisualLineBase(editor, visibleArea.y + visibleArea.height / lineHeight * lineHeight)));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor, editor.getCaretModel().getVisualPosition().line, visibleArea.height);
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    private static int adjustYToVisualLineBase(@NotNull Editor editor, int y) {
        int visualLineBaseY = editor.visualLineToY(editor.yToVisualLine(y));
        return y > visualLineBaseY && y < visualLineBaseY + editor.getLineHeight() ? visualLineBaseY : y;
    }

    private static int calcVisualLineIncrement(@NotNull Editor editor, int visualLine, int yIncrement) {
        int targetVisualLine;
        int targetVisualLineBase;
        int startY = editor.visualLineToY(visualLine) + (yIncrement > 0 ? editor.getLineHeight() - 1 : 0);
        int targetY = startY + yIncrement;
        if (targetY < (targetVisualLineBase = editor.visualLineToY(targetVisualLine = editor.yToVisualLine(targetY)))) {
            if (yIncrement < 0) {
                --targetVisualLine;
            }
        } else if (targetY >= targetVisualLineBase + editor.getLineHeight() && yIncrement > 0) {
            ++targetVisualLine;
        }
        return targetVisualLine - visualLine;
    }

    public static void moveCaretPageTop(@NotNull Editor editor, boolean isWithSelection) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int lineNumber = editor.yToVisualLine(visibleArea.y);
        if (visibleArea.y > editor.visualLineToY(lineNumber) && visibleArea.y + visibleArea.height > editor.visualLineToY(lineNumber + 1)) {
            ++lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageBottom(@NotNull Editor editor, boolean isWithSelection) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int maxY = visibleArea.y + visibleArea.height - editor.getLineHeight();
        int lineNumber = editor.yToVisualLine(maxY);
        if (lineNumber > 0 && maxY < editor.visualLineToY(lineNumber) && visibleArea.y <= editor.visualLineToY(lineNumber - 1)) {
            --lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    @NotNull
    private static Rectangle getVisibleArea(@NotNull Editor editor) {
        return SystemProperties.isTrueSmoothScrollingEnabled() ? editor.getScrollingModel().getVisibleAreaOnScrollingFinished() : editor.getScrollingModel().getVisibleArea();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static EditorPopupHandler createEditorPopupHandler(final @NotNull String groupId2) {
        return new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                    ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId2);
                    EditorActionUtil.showEditorPopup(event, group);
                }
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static EditorPopupHandler createEditorPopupHandler(final @NotNull ActionGroup group) {
        return new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                EditorActionUtil.showEditorPopup(event, group);
            }
        };
    }

    private static void showEditorPopup(EditorMouseEvent event, @NotNull ActionGroup group) {
        if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
            MouseEvent e = event.getMouseEvent();
            Component c = e.getComponent();
            if (c != null && c.isShowing()) {
                popupMenu.getComponent().show(c, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    private static boolean isBetweenWhitespaces(@NotNull CharSequence text, int offset) {
        return 0 < offset && offset < text.length() && Character.isWhitespace(text.charAt(offset - 1)) && Character.isWhitespace(text.charAt(offset));
    }

    public static boolean isWordStart(@NotNull CharSequence text, int offset, boolean isCamel) {
        return EditorActionUtil.isWordBoundary(text, offset, isCamel, true);
    }

    public static boolean isWordEnd(@NotNull CharSequence text, int offset, boolean isCamel) {
        return EditorActionUtil.isWordBoundary(text, offset, isCamel, false);
    }

    public static boolean isWordBoundary(@NotNull CharSequence text, int offset, boolean isCamel, boolean isStart) {
        char neighbor;
        if (offset < 0 || offset > text.length()) {
            return false;
        }
        char prev = offset > 0 ? text.charAt(offset - 1) : (char)'\u0000';
        char curr = offset < text.length() ? text.charAt(offset) : (char)'\u0000';
        char word = isStart ? curr : prev;
        char c = neighbor = isStart ? prev : curr;
        if (Character.isJavaIdentifierPart(word)) {
            if (!Character.isJavaIdentifierPart(neighbor)) {
                return true;
            }
            if (isCamel && EditorActionUtil.isHumpBound(text, offset, isStart)) {
                return true;
            }
        }
        return EditorActionUtil.isPunctuation(word) && !EditorActionUtil.isPunctuation(neighbor);
    }

    public static boolean isHumpBound(@NotNull CharSequence text, int offset, boolean isStart) {
        if (offset <= 0 || offset >= text.length()) {
            return false;
        }
        char prev = text.charAt(offset - 1);
        char curr = text.charAt(offset);
        char next = offset + 1 < text.length() ? text.charAt(offset + 1) : (char)'\u0000';
        char hump = isStart ? curr : prev;
        char neighbor = isStart ? prev : curr;
        return EditorActionUtil.isLowerCaseOrDigit(prev) && Character.isUpperCase(curr) || neighbor == '_' && hump != '_' || neighbor == '$' && Character.isLetterOrDigit(hump) || Character.isUpperCase(prev) && Character.isUpperCase(curr) && Character.isLowerCase(next);
    }

    private static boolean isLowerCaseOrDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    private static boolean isPunctuation(char c) {
        return !Character.isJavaIdentifierPart(c) && !Character.isWhitespace(c);
    }

    public static void moveCaretToLineStartIgnoringSoftWraps(@NotNull Editor editor) {
        editor.getCaretModel().moveToLogicalPosition((LogicalPosition)EditorUtil.calcCaretLineRange((Editor)editor).first);
    }

    public static void makePositionVisible(@NotNull Editor editor, int offset) {
        FoldRegion region;
        FoldingModel foldingModel = editor.getFoldingModel();
        while ((region = foldingModel.getCollapsedRegionAtOffset(offset)) != null && !region.shouldNeverExpand()) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
    }

    public static void moveCaret(@NotNull Caret caret, int offset, boolean withSelection) {
        if (withSelection) {
            caret.setSelection(caret.getLeadSelectionOffset(), offset);
        } else {
            caret.removeSelection();
        }
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)caret.getEditor());
    }
}

