/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CutLineEndAction
extends TextComponentEditorAction {
    public CutLineEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
            super(false);
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (caret == null && editor.getCaretModel().getCaretCount() > 1) {
                editor.getCaretModel().runForEachCaret(c -> c.setSelection(c.getOffset(), Handler.getEndOffset(c)));
                EditorCopyPasteHelper.getInstance().copySelectionToClipboard(editor);
                EditorModificationUtil.deleteSelectedTextForAllCarets((Editor)editor);
            } else {
                if (caret == null) {
                    caret = editor.getCaretModel().getCurrentCaret();
                }
                int startOffset = caret.getOffset();
                int endOffset = Handler.getEndOffset(caret);
                KillRingUtil.cut(editor, startOffset, endOffset);
                caret.moveToOffset(startOffset);
            }
        }

        private static int getEndOffset(@NotNull Caret caret) {
            Document document = caret.getEditor().getDocument();
            int startOffset = caret.getOffset();
            int endOffset = DocumentUtil.getLineEndOffset(startOffset, document);
            if (endOffset < document.getTextLength() && CharArrayUtil.isEmptyOrSpaces((CharSequence)document.getImmutableCharSequence(), (int)startOffset, (int)endOffset)) {
                ++endOffset;
            }
            return endOffset;
        }
    }
}

