/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import org.jetbrains.annotations.NotNull;

public final class ProjectDisposeAwareDocumentListener
implements DocumentListener {
    private final Project project;
    private final DocumentListener listener;

    @NotNull
    public static DocumentListener create(@NotNull Project project, @NotNull DocumentListener listener2) {
        return ProjectManagerImpl.isLight(project) ? new ProjectDisposeAwareDocumentListener(project, listener2) : listener2;
    }

    private ProjectDisposeAwareDocumentListener(@NotNull Project project, @NotNull DocumentListener listener2) {
        this.project = project;
        this.listener = listener2;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (!this.project.isDisposed()) {
            this.listener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (!this.project.isDisposed()) {
            this.listener.documentChanged(event);
        }
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        if (!this.project.isDisposed()) {
            this.listener.bulkUpdateStarting(document);
        }
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        if (!this.project.isDisposed()) {
            this.listener.bulkUpdateFinished(document);
        }
    }
}

