/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public interface IProjectStore
extends IComponentStore {
    @NotNull
    public Path getProjectBasePath();

    @NotNull
    public String getProjectName();

    @NotNull
    public StorageScheme getStorageScheme();

    public @SystemIndependent @NotNull String getProjectFilePath();

    public @SystemIndependent @Nullable String getProjectConfigDir();

    @Nullable
    public String getWorkspaceFilePath();

    public void clearStorages();

    public boolean isOptimiseTestLoadSpeed();

    public void setOptimiseTestLoadSpeed(boolean var1);

    public boolean isProjectFile(@NotNull VirtualFile var1);

    @Nullable
    public @SystemIndependent String getDirectoryStorePath(boolean var1);

    default public Path getDirectoryStorePath() {
        String result2 = this.getDirectoryStorePath(false);
        return result2 == null ? null : Paths.get(result2, new String[0]);
    }

    @NotNull
    public @SystemIndependent String getDirectoryStorePathOrBase();

    public void setPath(@NotNull Path var1, boolean var2, @Nullable Project var3);

    @Nullable
    public String getProjectWorkspaceId();
}

