/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.impl.FlushQueue;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.lang.reflect.Field;
import javax.swing.RepaintManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InvocationUtil {
    @NotNull
    public static final Class<? extends Runnable> FLUSH_NOW_CLASS = FlushQueue.FlushNow.class;
    @NotNull
    public static final Class<? extends Runnable> REPAINT_PROCESSING_CLASS = InvocationUtil.findProcessingClass();
    @NotNull
    private static final Field INVOCATION_EVENT_RUNNABLE_FIELD = InvocationUtil.findRunnableField();

    private InvocationUtil() {
    }

    @Nullable
    public static Runnable extractRunnable(@NotNull AWTEvent event) {
        return event instanceof InvocationEvent ? (Runnable)ReflectionUtil.getFieldValue((Field)INVOCATION_EVENT_RUNNABLE_FIELD, (Object)event) : null;
    }

    @NotNull
    private static Class<? extends Runnable> findProcessingClass() {
        try {
            return Class.forName("javax.swing.RepaintManager$ProcessingRunnable", false, InvocationUtil.class.getClassLoader()).asSubclass(Runnable.class);
        }
        catch (ClassNotFoundException e) {
            throw new InternalAPIChangedException(RepaintManager.class, e);
        }
    }

    @NotNull
    private static Field findRunnableField() {
        try {
            return ReflectionUtil.findAssignableField(InvocationEvent.class, Runnable.class, (String)"runnable");
        }
        catch (NoSuchFieldException e) {
            throw new InternalAPIChangedException(InvocationEvent.class, e);
        }
    }

    private static final class InternalAPIChangedException
    extends RuntimeException {
        InternalAPIChangedException(@NotNull Class<?> targetClass, @Nullable ReflectiveOperationException cause) {
            super(targetClass + " class internal API has been changed", cause);
        }
    }
}

