/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.AsyncExecutionService;
import com.intellij.openapi.application.ExpirableExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.impl.AppUIExecutorImpl;
import com.intellij.openapi.application.impl.ExecutionThread;
import com.intellij.openapi.application.impl.ExpirableExecutorImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class AsyncExecutionServiceImpl
extends AsyncExecutionService {
    private static long ourWriteActionCounter = 0L;

    public AsyncExecutionServiceImpl() {
        Application app = ApplicationManager.getApplication();
        app.addApplicationListener(new ApplicationListener(){

            public void writeActionStarted(@NotNull Object action2) {
                ourWriteActionCounter++;
            }
        }, (Disposable)app);
    }

    @NotNull
    protected ExpirableExecutor createExecutor(@NotNull Executor executor) {
        return new ExpirableExecutorImpl(executor);
    }

    @NotNull
    protected AppUIExecutor createUIExecutor(@NotNull ModalityState modalityState) {
        return new AppUIExecutorImpl(modalityState, ExecutionThread.EDT);
    }

    @NotNull
    protected AppUIExecutor createWriteThreadExecutor(@NotNull ModalityState modalityState) {
        return new AppUIExecutorImpl(modalityState, ExecutionThread.WT);
    }

    @NotNull
    public <T> NonBlockingReadAction<T> buildNonBlockingReadAction(@NotNull Callable<T> computation) {
        return new NonBlockingReadActionImpl<T>(computation);
    }

    static long getWriteActionCounter() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ourWriteActionCounter;
    }
}

