/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PlatformUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myCopyrightStart = "2000";
    private String myShortCompanyName;
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private long myProgressColor = -1L;
    private long myCopyrightForeground = -1L;
    private long myAboutForeground = -1L;
    private long myAboutLinkColor = -1L;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight = 2;
    private int myProgressY = 350;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee = true;
    private String myCustomizeIDEWizardStepsProvider;
    private final ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private final List<PluginId> myEssentialPluginsIds;
    private final String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
    private String myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private final List<ProgressSlide> myProgressSlides = new ArrayList<ProgressSlide>();
    private static final String ELEMENT_VERSION = "version";
    private static final String ATTRIBUTE_MAJOR = "major";
    private static final String ATTRIBUTE_MINOR = "minor";
    private static final String ATTRIBUTE_MICRO = "micro";
    private static final String ATTRIBUTE_PATCH = "patch";
    private static final String ATTRIBUTE_FULL = "full";
    private static final String ATTRIBUTE_CODENAME = "codename";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_BUILD = "build";
    private static final String ELEMENT_COMPANY = "company";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_API_VERSION = "apiVersion";
    private static final String ATTRIBUTE_DATE = "date";
    private static final String ATTRIBUTE_MAJOR_RELEASE_DATE = "majorReleaseDate";
    private static final String ELEMENT_LOGO = "logo";
    private static final String ATTRIBUTE_URL = "url";
    private static final String COPYRIGHT_START = "copyrightStart";
    private static final String ATTRIBUTE_PROGRESS_COLOR = "progressColor";
    private static final String ATTRIBUTE_ABOUT_FOREGROUND_COLOR = "foreground";
    private static final String ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR = "copyrightForeground";
    private static final String ATTRIBUTE_ABOUT_LINK_COLOR = "linkColor";
    private static final String ATTRIBUTE_PROGRESS_HEIGHT = "progressHeight";
    private static final String ATTRIBUTE_PROGRESS_Y = "progressY";
    private static final String ATTRIBUTE_PROGRESS_TAIL_ICON = "progressTailIcon";
    private static final String ELEMENT_ABOUT = "about";
    private static final String ELEMENT_ICON = "icon";
    private static final String ATTRIBUTE_SIZE16 = "size16";
    private static final String ATTRIBUTE_SIZE12 = "size12";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ELEMENT_LICENSEE = "licensee";
    private static final String ATTRIBUTE_SHOW = "show";
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    private static final String LOGO_URL_ATTR = "logo-url";
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    private static final String ATTRIBUTE_EAP = "eap";
    private static final String HELP_ELEMENT_NAME = "help";
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    private static final String ELEMENT_SUPPORT = "support";
    private static final String ELEMENT_YOUTRACK = "youtrack";
    private static final String ELEMENT_FEEDBACK = "feedback";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    private static final String ATTRIBUTE_CHANNEL_LIST_URL = "channel-list-url";
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    private static final String ATTRIBUTE_BUILTIN_URL = "builtin-url";
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    private static final String ATTRIBUTE_HAS_HELP = "has-help";
    private static final String ATTRIBUTE_HAS_CONTEXT_HELP = "has-context-help";
    private static final String ELEMENT_WHATS_NEW = "whatsnew";
    private static final String ELEMENT_KEYMAP = "keymap";
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    private static final String ATTRIBUTE_MAC_URL = "mac";
    private static final String ELEMENT_STATISTICS = "statistics";
    private static final String ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS = "event-log-settings";
    private static final String ELEMENT_JB_TV = "jetbrains-tv";
    private static final String CUSTOMIZE_IDE_WIZARD_STEPS = "customize-ide-wizard";
    private static final String STEPS_PROVIDER = "provider";
    private static final String ELEMENT_EVALUATION = "evaluation";
    private static final String ATTRIBUTE_EVAL_LICENSE_URL = "license-url";
    private static final String ELEMENT_LICENSING = "licensing";
    private static final String ATTRIBUTE_KEY_CONVERSION_URL = "key-conversion-url";
    private static final String ESSENTIAL_PLUGIN = "essential-plugin";
    private static final String ELEMENT_SUBSCRIPTIONS = "subscriptions";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_FORM_ID = "formid";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY = "news-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE = "news-value";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY = "tips-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE = "tips-available";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA = "additional-form-data";
    private static final String PROGRESS_SLIDE = "progressSlide";
    private static final String PROGRESS_PERCENT = "progressPercent";
    static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static volatile ApplicationInfoImpl instance;
    private static volatile boolean myInStressTest;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull Element element2) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        List<Element> essentialPluginsElements;
        Element whatsNewElement;
        Element feedbackElement;
        Element youtrackElement;
        Element supportElement;
        Element updateUrls;
        Element helpElement;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconEap;
        Element iconElement;
        Element aboutLogoElement;
        Element logoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = ApplicationInfoImpl.getChild(element2, ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myMicroVersion = versionElement.getAttributeValue(ATTRIBUTE_MICRO);
            this.myPatchVersion = versionElement.getAttributeValue(ATTRIBUTE_PATCH);
            this.myFullVersionFormat = versionElement.getAttributeValue(ATTRIBUTE_FULL);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
            this.myVersionSuffix = versionElement.getAttributeValue("suffix");
            if (this.myVersionSuffix == null && this.myEAP) {
                this.myVersionSuffix = "EAP";
            }
        }
        if ((companyElement = ApplicationInfoImpl.getChild(element2, ELEMENT_COMPANY)) != null) {
            this.myCompanyName = companyElement.getAttributeValue(ATTRIBUTE_NAME, this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue(ATTRIBUTE_URL, this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue(COPYRIGHT_START, this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(element2, ELEMENT_BUILD)) != null) {
            this.readBuildInfo(buildElement);
        }
        if ((logoElement = ApplicationInfoImpl.getChild(element2, ELEMENT_LOGO)) != null) {
            this.readLogoInfo(logoElement);
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(element2, ELEMENT_ABOUT)) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
            String v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_FOREGROUND_COLOR);
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR)) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_LINK_COLOR)) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(element2, ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16, this.mySmallIconUrl);
            this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(iconElement, "size128");
            String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(iconElement, ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
            this.mySvgIconUrl = iconElement.getAttributeValue("svg");
            this.mySmallSvgIconUrl = iconElement.getAttributeValue("svg-small");
        }
        if ((iconEap = ApplicationInfoImpl.getChild(element2, "icon-eap")) != null) {
            this.mySvgEapIconUrl = iconEap.getAttributeValue("svg");
            this.mySmallSvgEapIconUrl = iconEap.getAttributeValue("svg-small");
        }
        if ((packageElement = ApplicationInfoImpl.getChild(element2, ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(element2, ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.parseBoolean(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(element2, WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue(LOGO_URL_ATTR);
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(element2, CUSTOMIZE_IDE_WIZARD_STEPS)) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue(STEPS_PROVIDER);
        }
        if ((helpElement = ApplicationInfoImpl.getChild(element2, HELP_ELEMENT_NAME)) != null) {
            String attValue;
            String webHelpUrl = ApplicationInfoImpl.getAttributeValue(helpElement, ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_HELP)) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_CONTEXT_HELP);
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        this.myUpdateUrls = (updateUrls = ApplicationInfoImpl.getChild(element2, UPDATE_URLS_ELEMENT_NAME)) == null ? null : new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(element2, ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = ApplicationInfoImpl.getChild(element2, ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((youtrackElement = ApplicationInfoImpl.getChild(element2, ELEMENT_YOUTRACK)) != null) {
            this.myYoutrackUrl = youtrackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(element2, ELEMENT_FEEDBACK)) != null) {
            this.myFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((whatsNewElement = ApplicationInfoImpl.getChild(element2, ELEMENT_WHATS_NEW)) != null) {
            this.myWhatsNewUrl = whatsNewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        this.readPluginInfo(ApplicationInfoImpl.getChild(element2, ELEMENT_PLUGINS));
        Element keymapElement = ApplicationInfoImpl.getChild(element2, ELEMENT_KEYMAP);
        if (keymapElement != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        if ((essentialPluginsElements = ApplicationInfoImpl.getChildren(element2, ESSENTIAL_PLUGIN)).isEmpty()) {
            this.myEssentialPluginsIds = Collections.emptyList();
        } else {
            ArrayList<Object> essentialPluginsIds = new ArrayList<Object>(essentialPluginsElements.size());
            for (Element element1 : essentialPluginsElements) {
                String id2 = element1.getTextTrim();
                if (id2.isEmpty()) continue;
                essentialPluginsIds.add(PluginId.getId((String)id2));
            }
            essentialPluginsIds.sort(null);
            this.myEssentialPluginsIds = Collections.unmodifiableList(essentialPluginsIds);
        }
        Element statisticsElement = ApplicationInfoImpl.getChild(element2, ELEMENT_STATISTICS);
        this.myEventLogSettingsUrl = statisticsElement != null ? statisticsElement.getAttributeValue(ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS) : "https://resources.jetbrains.com/storage/fus/config/v3/%s/%s.json";
        Element tvElement = ApplicationInfoImpl.getChild(element2, ELEMENT_JB_TV);
        if (tvElement != null) {
            this.myJetBrainsTvUrl = tvElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(element2, ELEMENT_EVALUATION)) != null && (url2 = ApplicationInfoImpl.getAttributeValue(evaluationElement, ATTRIBUTE_EVAL_LICENSE_URL)) != null) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(element2, ELEMENT_LICENSING)) != null && (url = ApplicationInfoImpl.getAttributeValue(licensingElement, ATTRIBUTE_KEY_CONVERSION_URL)) != null) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(element2, ELEMENT_SUBSCRIPTIONS)) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_FORM_ID);
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY);
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE, "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY);
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA);
        }
    }

    private void readLogoInfo(@NotNull Element element2) {
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_URL);
        String v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_COLOR);
        if (v != null) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_TAIL_ICON)) != null) {
            this.myProgressTailIconName = v;
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_HEIGHT)) != null) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_Y)) != null) {
            this.myProgressY = Integer.parseInt(v);
        }
        for (Element child2 : ApplicationInfoImpl.getChildren(element2, PROGRESS_SLIDE)) {
            String slideUrl = child2.getAttributeValue(ATTRIBUTE_URL);
            assert (slideUrl != null);
            String progressPercentString = child2.getAttributeValue(PROGRESS_PERCENT);
            assert (progressPercentString != null);
            int progressPercentInt = Integer.parseInt(progressPercentString);
            assert (progressPercentInt <= 100 && progressPercentInt >= 0);
            float progressPercentFloat = (float)progressPercentInt / 100.0f;
            this.myProgressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            return result2;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity((String)"app info loading");
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result2;
        }
    }

    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @NotNull
    public BuildNumber getBuild() {
        return Objects.requireNonNull(BuildNumber.fromString((String)this.myBuildNumber));
    }

    @NotNull
    public String getApiVersion() {
        return this.getApiVersionAsNumber().asString();
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber build2 = this.getBuild();
        if (this.myApiVersion != null) {
            BuildNumber api = BuildNumber.fromStringWithProductCode((String)this.myApiVersion, (String)build2.getProductCode());
            if (api != null) {
                return api;
            }
        } else if (PlatformUtils.isAndroidStudio()) {
            assert (build2.getComponents().length >= 3);
            BuildNumber apiBuildNumber = new BuildNumber("AI", new int[]{build2.getComponents()[0], build2.getComponents()[1], build2.getComponents()[2]});
            return apiBuildNumber;
        }
        return build2;
    }

    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @NotNull
    public String getFullVersion() {
        String result2 = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : StringUtilRt.notNullize((String)this.myMajorVersion, (String)"0") + '.' + StringUtilRt.notNullize((String)this.myMinorVersion, (String)"0");
        return result2;
    }

    @NotNull
    public String getStrictVersion() {
        return this.myMajorVersion + "." + this.myMinorVersion + "." + StringUtilRt.notNullize((String)this.myMicroVersion, (String)"0") + "." + StringUtilRt.notNullize((String)this.myPatchVersion, (String)"0");
    }

    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && !StringUtilRt.isEmptyOrSpaces((CharSequence)this.myCodeName)) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    public String getCompanyName() {
        return this.myCompanyName;
    }

    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    @Override
    public long getProgressColor() {
        return this.myProgressColor;
    }

    @Override
    public long getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    @Override
    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    @Override
    public int getProgressY() {
        return this.myProgressY;
    }

    @Override
    @Nullable
    public String getProgressTailIcon() {
        return this.myProgressTailIconName;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public String getSmallIconUrl() {
        return this.mySmallIconUrl;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    @Nullable
    public String getApplicationSvgIconUrl() {
        return this.isEAP() && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
    }

    @Override
    @Nullable
    public String getSmallApplicationSvgIconUrl() {
        return this.isEAP() && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardStepsProvider() {
        return this.myCustomizeIDEWizardStepsProvider;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    public boolean hasHelp() {
        return this.myHasHelp;
    }

    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public long getAboutForeground() {
        return this.myAboutForeground;
    }

    public long getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getEventLogSettingsUrl() {
        return this.myEventLogSettingsUrl;
    }

    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Nullable
    public int[] getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    @Override
    public List<ProgressSlide> getProgressSlides() {
        return this.myProgressSlides;
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element2, @NotNull String name) {
        String value2 = element2.getAttributeValue(name);
        return value2 == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(@NotNull Element element2) {
        String majorReleaseDateString;
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_NUMBER);
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_API_VERSION);
        String dateString = element2.getAttributeValue(ATTRIBUTE_DATE);
        if ("__BUILD_DATE__".equals(dateString)) {
            this.myBuildDate = new GregorianCalendar();
            try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + "/lib/bootstrap.jar");){
                JarEntry jarEntry = bootstrapJar2.entries().nextElement();
                this.myBuildDate.setTime(new Date(jarEntry.getTime()));
            }
            catch (Exception bootstrapJar2) {}
        } else {
            this.myBuildDate = dateString == null ? Calendar.getInstance() : ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element2.getAttributeValue(ATTRIBUTE_MAJOR_RELEASE_DATE)) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable Element element2) {
        String pluginsHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element2 != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element2.getAttributeValue(ATTRIBUTE_URL);
            if (url != null) {
                String string = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element2.getAttributeValue(ATTRIBUTE_LIST_URL)) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element2.getAttributeValue(ATTRIBUTE_CHANNEL_LIST_URL)) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element2.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL)) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if (StringUtil.isNotEmpty((String)(builtinPluginsUrl = element2.getAttributeValue(ATTRIBUTE_BUILTIN_URL)))) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    @NotNull
    private static List<Element> getChildren(@NotNull Element parentNode, @NotNull String name) {
        return parentNode.getChildren(name, parentNode.getNamespace());
    }

    private static Element getChild(@NotNull Element parentNode, @NotNull String name) {
        return parentNode.getChild(name, parentNode.getNamespace());
    }

    static String shortenCompanyName(@NotNull String name) {
        if (name.endsWith(" s.r.o.")) {
            name = name.substring(0, name.length() - " s.r.o.".length());
        }
        if (name.endsWith(" Inc.")) {
            name = name.substring(0, name.length() - " Inc.".length());
        }
        return name;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    public static long parseColor(@NotNull String colorString) {
        return Long.parseLong(colorString, 16);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId((String)pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        return PluginManagerCore.CORE_ID == pluginId || Collections.binarySearch(this.myEssentialPluginsIds, pluginId) >= 0;
    }

    @NotNull
    public List<PluginId> getEssentialPluginsIds() {
        return this.myEssentialPluginsIds;
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    public static void setInStressTest(boolean inStressTest) {
        myInStressTest = inStressTest;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull Element element2) {
            this.myCheckingUrl = element2.getAttributeValue("check");
            this.myPatchesUrl = element2.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }
    }
}

