/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChameleonAction
extends AnAction {
    private final Map<ProjectType, AnAction> myActions = new HashMap<ProjectType, AnAction>();

    public ChameleonAction(@NotNull AnAction first, ProjectType projectType) {
        this.addAction(first, projectType);
        this.copyFrom(this.myActions.values().iterator().next());
    }

    public AnAction addAction(AnAction action2, ProjectType projectType) {
        if (action2 instanceof ActionStub) {
            String type = ((ActionStub)action2).getProjectType();
            if ((action2 = ActionManagerImpl.convertStub((ActionStub)action2)) == null) {
                return null;
            }
            projectType = type == null ? null : new ProjectType(type);
        }
        return this.myActions.put(projectType, action2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        AnAction action2 = this.getAction(e);
        assert (action2 != null);
        action2.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        AnAction action2 = this.getAction(e);
        if (action2 != null) {
            e.getPresentation().setVisible(true);
            action2.update(e);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @Nullable
    private AnAction getAction(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        AnAction action2 = this.myActions.get(projectType);
        if (action2 == null) {
            action2 = this.myActions.get(null);
        }
        return action2;
    }

    public Map<ProjectType, AnAction> getActions() {
        return this.myActions;
    }
}

