/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AndroidStudioSystemHealthMonitorAdapter;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventPair;
import com.intellij.internal.statistic.eventLog.ObjectEventData;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.DynamicActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.editor.actions.BackspaceAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final ExtensionPointName<ActionConfigurationCustomizer> EP = new ExtensionPointName("com.intellij.actionConfigurationCustomizer");
    private static final ExtensionPointName<EditorActionHandlerBean> EDITOR_ACTION_HANDLER_EP = new ExtensionPointName("com.intellij.editorActionHandler");
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    private static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String KEY_ATTR_NAME = "key";
    private static final String POPUP_ATTR_NAME = "popup";
    private static final String COMPACT_ATTR_NAME = "compact";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    private static final String GROUPID_ATTR_NAME = "group-id";
    private static final String ANCHOR_ELEMENT_NAME = "anchor";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SECONDARY = "secondary";
    private static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    private static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    private static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    private static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String KEYSTROKE_ATTR_NAME = "keystroke";
    private static final String REF_ATTR_NAME = "ref";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String OVERRIDES_ATTR_NAME = "overrides";
    private static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    private static final String PROJECT_TYPE = "project-type";
    private static final String UNREGISTER_ELEMENT_NAME = "unregister";
    private static final String OVERRIDE_TEXT_ELEMENT_NAME = "override-text";
    private static final String PLACE_ATTR_NAME = "place";
    private static final String USE_TEXT_OF_PLACE_ATTR_NAME = "use-text-of-place";
    private static final String RESOURCE_BUNDLE_ATTR_NAME = "resource-bundle";
    private static final Logger LOG = Logger.getInstance(ActionManagerImpl.class);
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> myId2Action = new Object2ObjectOpenHashMap();
    private final MultiMap<PluginId, String> myPlugin2Id = new MultiMap();
    private final Object2IntMap<String> myId2Index = new Object2IntOpenHashMap();
    private final Map<Object, String> myAction2Id = new Object2ObjectOpenHashMap();
    private final MultiMap<String, String> myId2GroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private boolean myTransparentOnlyUpdate;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private int myAnonymousGroupIdCounter;
    private boolean myPreloadComplete;
    private static final Map<Class<?>, Boolean> ourActionsExcludedFromTracking = new IdentityHashMap();

    ActionManagerImpl() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode()) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            if (!app.isHeadlessEnvironment() && !app.isCommandLine()) {
                LOG.assertTrue(!app.isDispatchThread());
            }
        }
        for (IdeaPluginDescriptorImpl plugin : PluginManagerCore.getLoadedPlugins(null)) {
            this.registerPluginActions(plugin, plugin.getActionDescriptionElements(), true);
        }
        EP.forEachExtensionSafe(customizer -> customizer.customize((ActionManager)this));
        DynamicActionConfigurationCustomizer.EP_NAME.forEachExtensionSafe(customizer -> customizer.registerActions((ActionManager)this));
        DynamicActionConfigurationCustomizer.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DynamicActionConfigurationCustomizer>(){

            public void extensionAdded(@NotNull DynamicActionConfigurationCustomizer extension, @NotNull PluginDescriptor pluginDescriptor) {
                extension.registerActions((ActionManager)ActionManagerImpl.this);
            }

            public void extensionRemoved(@NotNull DynamicActionConfigurationCustomizer extension, @NotNull PluginDescriptor pluginDescriptor) {
                extension.unregisterActions((ActionManager)ActionManagerImpl.this);
            }
        }, (Disposable)this);
        EDITOR_ACTION_HANDLER_EP.addChangeListener(this::updateAllHandlers, (Disposable)this);
    }

    @NotNull
    private static AnActionListener publisher() {
        return (AnActionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AnActionListener.TOPIC);
    }

    @Nullable
    static AnAction convertStub(@NotNull ActionStub stub) {
        AnAction anAction = ActionManagerImpl.instantiate(stub.getClassName(), stub.getPlugin(), AnAction.class);
        if (anAction == null) {
            return null;
        }
        stub.initAction(anAction);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, anAction);
        return anAction;
    }

    @Nullable
    private static <T> T instantiate(@NotNull String stubClassName, @NotNull PluginDescriptor pluginDescriptor, Class<T> expectedClass) {
        Object obj;
        try {
            obj = expectedClass == ActionGroup.class ? ApplicationManager.getApplication().instantiateExtensionWithPicoContainerOnlyIfNeeded(stubClassName, pluginDescriptor) : ReflectionUtil.newInstance(Class.forName(stubClassName, true, pluginDescriptor.getPluginClassLoader()), (boolean)false);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (Throwable e) {
            LOG.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
            return null;
        }
        if (!expectedClass.isInstance(obj)) {
            LOG.error((Throwable)new PluginException("class with name '" + stubClassName + "' must be an instance of '" + expectedClass.getName() + "'; got " + obj, pluginDescriptor.getPluginId()));
            return null;
        }
        return (T)obj;
    }

    private static void updateIconFromStub(@NotNull ActionStubBase stub, AnAction anAction) {
        String iconPath = stub.getIconPath();
        if (iconPath == null) {
            return;
        }
        ActionManagerImpl.setIconFromClass(anAction.getClass(), stub.getPlugin(), iconPath, anAction.getTemplatePresentation());
    }

    @Nullable
    private static ActionGroup convertGroupStub(@NotNull ActionGroupStub stub, @NotNull ActionManager actionManager) {
        IdeaPluginDescriptor plugin = stub.getPlugin();
        ActionGroup group = ActionManagerImpl.instantiate(stub.getActionClass(), (PluginDescriptor)plugin, ActionGroup.class);
        if (group == null) {
            return null;
        }
        stub.initGroup(group, actionManager);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, (AnAction)group);
        return group;
    }

    private static void processAbbreviationNode(@NotNull Element e, @NotNull String id2) {
        String abbr = e.getAttributeValue(VALUE_ATTR_NAME);
        if (!StringUtil.isEmpty((String)abbr)) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id2, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(@NotNull IdeaPluginDescriptor plugin, @Nullable String bundleName) {
        String resBundleName = bundleName != null ? bundleName : (plugin.getPluginId() != PluginManagerCore.CORE_ID ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE);
        return resBundleName == null ? null : DynamicBundle.INSTANCE.getResourceBundle(resBundleName, plugin.getPluginClassLoader());
    }

    private static boolean isSecondary(Element element2) {
        return "true".equalsIgnoreCase(element2.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull Presentation presentation2) {
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, pluginDescriptor.getPluginClassLoader());
            ActionManagerImpl.setIconFromClass(actionClass, pluginDescriptor, iconPath, presentation2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.error(e);
            ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class<?> actionClass, final @NotNull PluginDescriptor pluginDescriptor, final @NotNull String iconPath, @NotNull Presentation presentation2) {
        presentation2.setIcon((Icon)new IconLoader.LazyIcon(){

            @NotNull
            protected Icon compute() {
                Icon icon2 = IconLoader.findIcon((String)iconPath, (Class)actionClass, (boolean)true, (boolean)false);
                if (icon2 == null) {
                    icon2 = IconLoader.findIcon((String)iconPath, (ClassLoader)pluginDescriptor.getPluginClassLoader());
                }
                if (icon2 == null) {
                    ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                    return AllIcons.Nodes.Unknown;
                }
                return icon2;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }
        });
    }

    private static String computeDescription(ResourceBundle bundle, String id2, String elementType, String descriptionValue) {
        if (bundle != null) {
            String key = elementType + "." + id2 + ".description";
            return AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)StringUtil.notNullize((String)descriptionValue), (Object[])new Object[0]);
        }
        return descriptionValue;
    }

    private static String computeActionText(ResourceBundle bundle, String id2, String elementType, String textValue) {
        return AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id2 + "." + TEXT_ATTR_NAME), (String)StringUtil.notNullize((String)textValue), (Object[])new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        MouseShortcut shortcut;
        String keystrokeString = element2.getAttributeValue(KEYSTROKE_ATTR_NAME);
        if (keystrokeString == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)shortcut);
    }

    private void assertActionIsGroupOrStub(AnAction action2) {
        if (this.myPreloadComplete) {
            return;
        }
        if (!(action2 instanceof ActionGroup || action2 instanceof ActionStub || action2 instanceof ChameleonAction)) {
            LOG.error("Action : " + action2 + "; class: " + action2.getClass());
        }
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message) {
        ActionManagerImpl.reportActionError(pluginId, message, null);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message, @Nullable Throwable cause) {
        if (pluginId != null) {
            LOG.error((Throwable)new PluginException(message, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message, cause);
        } else {
            LOG.error(message);
        }
    }

    private static void reportKeymapNotFoundWarning(@Nullable PluginId pluginId, @NotNull String keymapName) {
        if (DefaultKeymap.isBundledKeymapHidden(keymapName)) {
            return;
        }
        String message = "keymap \"" + keymapName + "\" not found";
        LOG.warn(pluginId == null ? message : new PluginException(message, null, pluginId).getMessage());
    }

    private static String getPluginInfo(@Nullable PluginId id2) {
        IdeaPluginDescriptor plugin;
        if (id2 != null && (plugin = PluginManagerCore.getPlugin(id2)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id2.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        return contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, @NotNull TimerListener listener2) {
        this._addTimerListener(listener2, false);
    }

    public void removeTimerListener(@NotNull TimerListener listener2) {
        this._removeTimerListener(listener2, false);
    }

    public void addTransparentTimerListener(int delay, @NotNull TimerListener listener2) {
        this._addTimerListener(listener2, true);
    }

    public void removeTransparentTimerListener(@NotNull TimerListener listener2) {
        this._removeTimerListener(listener2, true);
    }

    private void _addTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener2, transparent);
    }

    private void _removeTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener2, transparent);
        }
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group) {
        return new ActionPopupMenuImpl(place, group, this, null);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal) {
        return this.createActionToolbar(place, group, horizontal, false);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        return new ActionToolbarImpl(place, group, horizontal, decorateButtons);
    }

    public void registerPluginActions(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable List<Element> actionDescriptionElements, boolean initialStartup) {
        if (actionDescriptionElements == null) {
            return;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        for (Element e : actionDescriptionElements) {
            Element parent = e.getParentElement();
            String bundleName = parent == null ? null : parent.getAttributeValue(RESOURCE_BUNDLE_ATTR_NAME);
            this.processActionsChildElement(e, plugin, ActionManagerImpl.getActionsResourceBundle(plugin, bundleName), initialStartup);
        }
        StartUpMeasurer.addPluginCost((String)plugin.getPluginId().getIdString(), (String)"Actions", (long)(StartUpMeasurer.getCurrentTime() - startTime));
    }

    @Nullable
    public AnAction getAction(@NotNull String id2) {
        return this.getActionImpl(id2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id2, boolean canReturnStub) {
        AnAction converted;
        AnAction action2;
        Object object = this.myLock;
        synchronized (object) {
            action2 = this.myId2Action.get(id2);
            if (canReturnStub || !(action2 instanceof ActionStubBase)) {
                return action2;
            }
        }
        Object object2 = converted = action2 instanceof ActionStub ? ActionManagerImpl.convertStub((ActionStub)action2) : ActionManagerImpl.convertGroupStub((ActionGroupStub)action2, (ActionManager)this);
        if (converted == null) {
            this.unregisterAction(id2);
            return null;
        }
        Object object3 = this.myLock;
        synchronized (object3) {
            action2 = this.myId2Action.get(id2);
            if (action2 instanceof ActionStubBase) {
                action2 = this.replaceStub((ActionStubBase)action2, converted);
            }
            return action2;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStubBase stub, AnAction anAction) {
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action2 = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action2 != null);
        LOG.assertTrue(action2.equals(stub));
        this.myAction2Id.put(anAction, stub.getId());
        ActionManagerImpl.updateHandlers(anAction);
        return this.addToMap(stub.getId(), anAction, stub.getPlugin().getPluginId(), stub instanceof ActionStub ? ((ActionStub)stub).getProjectType() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action2) {
        if (action2 instanceof ActionStubBase) {
            return ((ActionStubBase)action2).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String @NotNull [] getActionIds(@NotNull String idPrefix) {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> idList = new ArrayList<String>();
            for (String id2 : this.myId2Action.keySet()) {
                if (!id2.startsWith(idPrefix)) continue;
                idList.add(id2);
            }
            return ArrayUtilRt.toStringArray(idList);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        return new ButtonToolbarImpl(actionPlace, messageActionGroup);
    }

    public AnAction getActionOrStub(@NotNull String id2) {
        return this.getActionImpl(id2, true);
    }

    @Nullable
    private AnAction processActionElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle) {
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "action element should have specified \"class\" attribute");
            return null;
        }
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id2);
            return null;
        }
        String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
        String projectType = element2.getAttributeValue(PROJECT_TYPE);
        String textValue = element2.getAttributeValue(TEXT_ATTR_NAME);
        String descriptionValue = element2.getAttributeValue(DESCRIPTION);
        ActionStub stub = new ActionStub(className, id2, (PluginDescriptor)plugin, iconPath, projectType, () -> {
            String text = ActionManagerImpl.computeActionText(bundle, id2, ACTION_ELEMENT_NAME, textValue);
            if (text == null) {
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "'text' attribute is mandatory (actionId=" + id2 + ", plugin=" + plugin + ")");
            }
            Presentation presentation2 = new Presentation();
            presentation2.setText(text);
            presentation2.setDescription(ActionManagerImpl.computeDescription(bundle, id2, ACTION_ELEMENT_NAME, descriptionValue));
            return presentation2;
        });
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (Element e : element2.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, plugin.getPluginId(), ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processKeyboardShortcutNode(e, id2, plugin.getPluginId(), keymapManager2);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processMouseShortcutNode(e, id2, plugin.getPluginId(), keymapManager2);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id2);
                continue;
            }
            if (OVERRIDE_TEXT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processOverrideTextNode(stub, e, plugin.getPluginId(), bundle);
                continue;
            }
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
        if (shortcutOfActionId != null) {
            keymapManager2.bindShortcuts(shortcutOfActionId, id2);
        }
        this.registerOrReplaceActionInner(element2, id2, (AnAction)stub, plugin);
        return stub;
    }

    private static String obtainActionId(Element element2, String className) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        return StringUtil.isEmpty((String)id2) ? StringUtil.getShortName((String)className) : id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element2, @NotNull String id2, @NotNull AnAction action2, @NotNull IdeaPluginDescriptor plugin) {
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.parseBoolean(element2.getAttributeValue(OVERRIDES_ATTR_NAME))) {
                if (this.getActionOrStub(id2) == null) {
                    LOG.error(element2.getName() + " '" + id2 + "' doesn't override anything");
                    return;
                }
                AnAction prev = this.replaceAction(id2, action2, plugin.getPluginId());
                if (action2 instanceof DefaultActionGroup && prev instanceof DefaultActionGroup && Boolean.parseBoolean(element2.getAttributeValue(KEEP_CONTENT_ATTR_NAME))) {
                    ((DefaultActionGroup)action2).copyFromGroup((DefaultActionGroup)prev);
                }
            } else {
                this.registerAction(id2, action2, plugin.getPluginId(), element2.getAttributeValue(PROJECT_TYPE));
            }
            ActionsCollectorImpl.onActionLoadedFromXml(action2, id2, plugin);
        }
    }

    private AnAction processGroupElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle) {
        if (!GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + element2.getName() + "\"");
            return null;
        }
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element2.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            DefaultActionGroup group;
            String id2 = element2.getAttributeValue(ID_ATTR_NAME);
            if (id2 != null && id2.isEmpty()) {
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "ID of the group cannot be an empty string");
                return null;
            }
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else if (id2 == null) {
                Object obj = ApplicationManager.getApplication().instantiateExtensionWithPicoContainerOnlyIfNeeded(className, (PluginDescriptor)plugin);
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin.getPluginId(), "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element2.getChildren().size() != element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin.getPluginId(), "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group = (ActionGroup)obj;
            } else {
                group = new ActionGroupStub(id2, className, (IdeaPluginDescriptor)plugin);
                customClass = true;
            }
            if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id2);
                return null;
            }
            if (id2 == null) {
                id2 = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element2, id2, (AnAction)group, plugin);
            Presentation presentation2 = group.getTemplatePresentation();
            String text = ActionManagerImpl.computeActionText(bundle, id2, GROUP_ELEMENT_NAME, element2.getAttributeValue(TEXT_ATTR_NAME));
            if (!StringUtil.isEmpty((String)text) || presentation2.getText() == null) {
                presentation2.setText(text);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.computeDescription(bundle, id2, GROUP_ELEMENT_NAME, element2.getAttributeValue(DESCRIPTION)))) || presentation2.getDescription() == null) {
                presentation2.setDescription(description);
            }
            String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
            if (group instanceof ActionGroupStub) {
                ((ActionGroupStub)group).setIconPath(iconPath);
            } else {
                ActionManagerImpl.setIcon(iconPath, className, (PluginDescriptor)plugin, presentation2);
            }
            String popup2 = element2.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group.setPopup(Boolean.parseBoolean(popup2));
                if (group instanceof ActionGroupStub) {
                    ((ActionGroupStub)group).setPopupDefinedInXml(true);
                }
            }
            String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
            if (customClass && shortcutOfActionId != null) {
                KeymapManagerEx.getInstanceEx().bindShortcuts(shortcutOfActionId, id2);
            }
            for (Element child2 : element2.getChildren()) {
                AnAction action2;
                String name = child2.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action2 = this.processActionElement(child2, plugin, bundle);
                    if (action2 == null) continue;
                    this.assertActionIsGroupOrStub(action2);
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group, child2, plugin.getPluginId(), bundle);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action2 = this.processGroupElement(child2, plugin, bundle);
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child2, plugin.getPluginId(), ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action2 = this.processReferenceElement(child2, plugin.getPluginId());
                    if (action2 == null) continue;
                    this.assertActionIsGroupOrStub(action2);
                    this.addToGroupInner((AnAction)group, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(plugin.getPluginId(), message, e);
            return null;
        }
    }

    private void processReferenceNode(Element element2, PluginId pluginId, boolean initialStartup) {
        AnAction action2 = this.processReferenceElement(element2, pluginId);
        if (action2 == null) {
            return;
        }
        if (initialStartup) {
            this.assertActionIsGroupOrStub(action2);
        }
        for (Element child2 : element2.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode(action2, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processAddToGroupNode(AnAction action2, Element element2, PluginId pluginId, boolean secondary) {
        if (!(action2 instanceof Separator)) {
            this.assertActionIsGroupOrStub(action2);
        }
        String name = action2 instanceof ActionStub ? ((ActionStub)action2).getClassName() : action2.getClass().getName();
        String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2);
        String actionName = name + " (" + id2 + ")";
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        DefaultActionGroup parentGroup = this.getParentGroup(element2.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element2.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element2.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner((AnAction)parentGroup, action2, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action2, Constraints constraints2, boolean secondary) {
        String actionId = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.myAction2Id.get(action2);
        ((DefaultActionGroup)group).addAction(action2, constraints2, (ActionManager)this).setAsSecondary(secondary);
        this.myId2GroupId.putValue((Object)actionId, (Object)this.myAction2Id.get(group));
    }

    @Nullable
    public DefaultActionGroup getParentGroup(String groupId2, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId2 == null || groupId2.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId2, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + (parentGroup != null ? parentGroup.getClass() : "[null]"));
            return null;
        }
        return (DefaultActionGroup)parentGroup;
    }

    private static void processOverrideTextNode(ActionStub stub, Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        if (!OVERRIDE_TEXT_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String place = element2.getAttributeValue(PLACE_ATTR_NAME);
        if (place == null) {
            ActionManagerImpl.reportActionError(pluginId, stub.getId() + ": override-text specified without place");
            return;
        }
        String useTextOfPlace = element2.getAttributeValue(USE_TEXT_OF_PLACE_ATTR_NAME);
        if (useTextOfPlace != null) {
            stub.copyActionTextOverride(useTextOfPlace, place);
        } else {
            String text = element2.getAttributeValue(TEXT_ATTR_NAME, "");
            if (text.isEmpty() && bundle != null) {
                String key = "action." + stub.getId() + "." + place + ".text";
                stub.addActionTextOverride(place, () -> BundleBase.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]));
            } else {
                stub.addActionTextOverride(place, () -> text);
            }
        }
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, @NotNull Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        Separator separator;
        if (!SEPARATOR_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String text = element2.getAttributeValue(TEXT_ATTR_NAME);
        String key = element2.getAttributeValue(KEY_ATTR_NAME);
        Separator separator2 = text != null ? new Separator(text) : (separator = key != null ? ActionManagerImpl.createSeparator(bundle, key) : Separator.getInstance());
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Element child2 : element2.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    @NotNull
    private static Separator createSeparator(@Nullable ResourceBundle bundle, @NotNull String key) {
        String text = bundle != null ? AbstractBundle.messageOrNull((ResourceBundle)bundle, (String)key, (Object[])new Object[0]) : null;
        return text != null ? new Separator(text) : Separator.getInstance();
    }

    private void processUnregisterNode(Element element2, PluginId pluginId) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action2 = this.getAction(id2);
        if (action2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id2);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id2);
        this.unregisterAction(id2);
    }

    private static void processKeyboardShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManagerEx keymapManager2) {
        String firstStrokeString = element2.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME);
        if (firstStrokeString == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element2.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element2, String actionId, @NotNull Keymap keymap2, @NotNull Shortcut shortcut) {
        boolean remove = Boolean.parseBoolean(element2.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element2.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove) {
            keymap2.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap2.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap2.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element2, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return null;
        }
        String ref = ActionManagerImpl.getReferenceActionId(element2);
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action2 = this.getActionImpl(ref, true);
        if (action2 == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        return action2;
    }

    private static String getReferenceActionId(@NotNull Element element2) {
        String ref = element2.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element2.getAttributeValue(ID_ATTR_NAME);
        }
        return ref;
    }

    private void processActionsChildElement(@NotNull Element child2, @NotNull IdeaPluginDescriptorImpl plugin, @Nullable ResourceBundle bundle, boolean initialStartup) {
        String name;
        switch (name = child2.getName()) {
            case "action": {
                AnAction action2 = this.processActionElement(child2, plugin, bundle);
                if (action2 == null) break;
                this.assertActionIsGroupOrStub(action2);
                break;
            }
            case "group": {
                this.processGroupElement(child2, plugin, bundle);
                break;
            }
            case "separator": {
                this.processSeparatorNode(null, child2, plugin.getPluginId(), bundle);
                break;
            }
            case "reference": {
                this.processReferenceNode(child2, plugin.getPluginId(), initialStartup);
                break;
            }
            case "unregister": {
                this.processUnregisterNode(child2, plugin.getPluginId());
                break;
            }
            default: {
                ActionManagerImpl.reportActionError(plugin.getPluginId(), "unexpected name of element \"" + name + "\n");
            }
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static String checkUnloadActions(PluginId pluginId, @NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<Element> elements2 = pluginDescriptor.getActionDescriptionElements();
        if (elements2 == null) {
            return null;
        }
        for (Element element2 : elements2) {
            if (element2.getName().equals(ACTION_ELEMENT_NAME) || element2.getName().equals(GROUP_ELEMENT_NAME) && ActionManagerImpl.canUnloadGroup(element2) || element2.getName().equals(REFERENCE_ELEMENT_NAME)) continue;
            return "Plugin " + pluginId + " is not unload-safe because of action element " + element2.getName();
        }
        return null;
    }

    private static boolean canUnloadGroup(@NotNull Element element2) {
        if (element2.getAttributeValue(ID_ATTR_NAME) == null) {
            return false;
        }
        for (Element child2 : element2.getChildren()) {
            if (!child2.getName().equals(GROUP_ELEMENT_NAME) || ActionManagerImpl.canUnloadGroup(child2)) continue;
            return false;
        }
        return true;
    }

    public void unloadActions(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<Element> elements2 = pluginDescriptor.getActionDescriptionElements();
        if (elements2 == null) {
            return;
        }
        for (Element element2 : ContainerUtil.reverse(elements2)) {
            switch (element2.getName()) {
                case "action": {
                    this.unloadActionElement(element2);
                    break;
                }
                case "group": {
                    this.unloadGroupElement(element2);
                    break;
                }
                case "reference": {
                    PluginId pluginId = pluginDescriptor.getPluginId();
                    AnAction action2 = this.processReferenceElement(element2, pluginId);
                    if (action2 == null) {
                        return;
                    }
                    String actionId = ActionManagerImpl.getReferenceActionId(element2);
                    for (Element child2 : element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME)) {
                        String groupId2 = child2.getAttributeValue(GROUPID_ATTR_NAME);
                        DefaultActionGroup parentGroup = this.getParentGroup(groupId2, actionId, pluginId);
                        if (parentGroup == null) {
                            return;
                        }
                        parentGroup.remove(action2);
                        this.myId2GroupId.remove((Object)actionId, (Object)groupId2);
                    }
                    break;
                }
            }
        }
    }

    private void unloadGroupElement(Element element2) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            throw new IllegalStateException("Cannot unload groups with no ID");
        }
        for (Element groupChild : element2.getChildren()) {
            if (groupChild.getName().equals(ACTION_ELEMENT_NAME)) {
                this.unloadActionElement(groupChild);
                continue;
            }
            if (!groupChild.getName().equals(GROUP_ELEMENT_NAME)) continue;
            this.unloadGroupElement(groupChild);
        }
        this.unregisterAction(id2);
    }

    private void unloadActionElement(@NotNull Element element2) {
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        this.unregisterAction(id2);
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        this.registerAction(actionId, action2, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId, @Nullable String projectType) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action2, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action2)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action2) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action2, actionId);
            if (pluginId != null && !(action2 instanceof ActionGroup)) {
                this.myPlugin2Id.putValue((Object)pluginId, (Object)actionId);
            }
            action2.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId), null);
            ActionManagerImpl.notifyCustomActionsSchema(actionId);
            ActionManagerImpl.updateHandlers(action2);
        }
    }

    private static void notifyCustomActionsSchema(@NotNull String registeredID) {
        CustomActionsSchema schema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
        if (schema == null) {
            return;
        }
        for (ActionUrl url : schema.getActions()) {
            if (!registeredID.equals(url.getComponent())) continue;
            schema.incrementModificationStamp();
            break;
        }
    }

    private AnAction addToMap(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action2, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action2);
        return action2;
    }

    private AnAction registerChameleon(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action2, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action2, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action2 + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2) {
        this.registerAction(actionId, action2, null);
    }

    public void unregisterAction(@NotNull String actionId) {
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action with ID " + actionId + " wasn't registered");
                }
                return;
            }
            AnAction actionToRemove = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(actionToRemove);
            this.myId2Index.removeInt((Object)actionId);
            for (Object entry : this.myPlugin2Id.entrySet()) {
                ((Collection)entry.getValue()).remove(actionId);
            }
            if (removeFromGroups) {
                CustomActionsSchema customActionSchema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
                for (String groupId2 : this.myId2GroupId.get((Object)actionId)) {
                    DefaultActionGroup group;
                    if (customActionSchema != null) {
                        customActionSchema.invalidateCustomizedActionGroup(groupId2);
                    }
                    if ((group = (DefaultActionGroup)this.getActionOrStub(groupId2)) == null) {
                        LOG.error("Trying to remove action " + actionId + " from non-existing group " + groupId2);
                        continue;
                    }
                    group.remove(actionToRemove, actionId);
                    if (group instanceof ActionGroupStub) continue;
                    for (String parentOfGroup : this.myId2GroupId.get((Object)groupId2)) {
                        DefaultActionGroup parentOfGroupAction = (DefaultActionGroup)this.getActionOrStub(parentOfGroup);
                        if (parentOfGroupAction == null) {
                            LOG.error("Trying to remove action " + actionId + " from non-existing group " + parentOfGroup);
                            continue;
                        }
                        for (AnAction stub : parentOfGroupAction.getChildActionsOrStubs()) {
                            if (!(stub instanceof ActionGroupStub) || ((ActionGroupStub)stub).getId() != groupId2) continue;
                            ((ActionGroupStub)stub).remove(actionToRemove, actionId);
                        }
                    }
                }
            }
            if (actionToRemove instanceof ActionGroup) {
                for (Object entry : this.myId2GroupId.entrySet()) {
                    ((Collection)entry.getValue()).remove(actionId);
                }
            }
            ActionManagerImpl.updateHandlers(actionToRemove);
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        return Comparator.comparingInt(arg_0 -> this.myId2Index.getInt(arg_0));
    }

    public String @NotNull [] getPluginActions(@NotNull PluginId pluginName) {
        return ArrayUtilRt.toStringArray((Collection)this.myPlugin2Id.get((Object)pluginName));
    }

    public void addActionPopup(@NotNull Object menu) {
        this.myPopups.add(menu);
        if (menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu);
            }
        }
    }

    void removeActionPopup(@NotNull Object menu) {
        boolean removed = this.myPopups.remove(menu);
        if (removed && menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu);
            }
        }
    }

    public void queueActionPerformedEvent(@NotNull AnAction action2, @NotNull DataContext context, @NotNull AnActionEvent event) {
        if (this.myPopups.isEmpty()) {
            this.fireAfterActionPerformed(action2, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        PluginId pluginId = callerClass != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        AnAction anAction = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)newAction, oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId2 : this.myId2GroupId.get((Object)actionId)) {
                DefaultActionGroup group = (DefaultActionGroup)this.getActionOrStub(groupId2);
                if (group == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId2);
                }
                group.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (!ourActionsExcludedFromTracking.containsKey(action2.getClass())) {
            AndroidStudioSystemHealthMonitorAdapter.countActionInvocation(action2.getClass(), action2.getTemplatePresentation(), event);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action2);
        if (this.myLastPreformedActionId == null && action2 instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)action2).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Language language = file2 != null ? file2.getLanguage() : null;
        ArrayList<EventPair> customData = new ArrayList<EventPair>();
        customData.add(EventFields.CurrentFile.with((Object)language));
        if (action2 instanceof FusAwareAction) {
            List<EventPair> additionalUsageData = ((FusAwareAction)action2).getAdditionalUsageData(event);
            customData.add(ActionsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(additionalUsageData.toArray(new EventPair[0]))));
        }
        ActionsCollectorImpl.recordActionInvoked((Project)CommonDataKeys.PROJECT.getData(dataContext), action2, event, customData);
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action2, dataContext, event);
        }
        ActionManagerImpl.publisher().beforeActionPerformed(action2, dataContext, event);
    }

    public void fireAfterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action2);
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action2, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        ActionManagerImpl.publisher().afterActionPerformed(action2, dataContext, event);
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action2.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, @NotNull DataContext dataContext) {
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().beforeEditorTyping(c, dataContext);
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> getActionIds() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myId2Action.keySet());
        }
    }

    public void preloadActions(@NotNull ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        for (String id2 : this.getActionIds()) {
            indicator.checkCanceled();
            if (application.isDisposed()) {
                return;
            }
            AnAction action2 = this.getAction(id2);
            if (!(action2 instanceof PreloadableAction)) continue;
            ((PreloadableAction)action2).preload();
        }
        this.myPreloadComplete = true;
    }

    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action2, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        return result2;
    }

    private void tryToExecuteNow(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, String place, ActionCallback result2) {
        Presentation presentation2 = action2.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation2, (ActionManager)this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component2 != null && !component2.isShowing() && !"TouchBarGeneral".equals(place)) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action2, context, event);
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, (long)64L, (Disposable)result2);
            ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
            result2.setDone();
            this.queueActionPerformedEvent(action2, context, event);
        }), ModalityState.defaultModalityState());
    }

    @NotNull
    public List<EditorActionHandlerBean> getRegisteredHandlers(@NotNull EditorAction editorAction) {
        ArrayList<EditorActionHandlerBean> result2 = new ArrayList<EditorActionHandlerBean>();
        String id2 = this.getId((AnAction)editorAction);
        if (id2 != null) {
            List extensions2 = EDITOR_ACTION_HANDLER_EP.getExtensionList();
            for (int i2 = extensions2.size() - 1; i2 >= 0; --i2) {
                EditorActionHandlerBean handlerBean = (EditorActionHandlerBean)extensions2.get(i2);
                if (!handlerBean.action.equals(id2)) continue;
                result2.add(handlerBean);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllHandlers() {
        Object object = this.myLock;
        synchronized (object) {
            this.myAction2Id.keySet().forEach(ActionManagerImpl::updateHandlers);
        }
    }

    private static void updateHandlers(Object action2) {
        if (action2 instanceof EditorAction) {
            ((EditorAction)action2).clearDynamicHandlersCache();
        }
    }

    static {
        ourActionsExcludedFromTracking.put(BackspaceAction.class, Boolean.TRUE);
    }

    private final class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    MyTimer.this.setDelay(5000);
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        void addTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener2);
        }

        void removeTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount && !Registry.is((String)"actionSystem.always.update.toolbar.actions")) {
                return;
            }
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                HashSet notified = new HashSet();
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<? extends TimerListener> timerListeners, Set<? super TimerListener> notified) {
            for (TimerListener timerListener : timerListeners) {
                if (!notified.add((TimerListener)timerListener)) continue;
                this.runListenerAction(timerListener);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState = listener2.getModalityState();
            if (modalityState == null) {
                return;
            }
            LOG.debug("notify ", new Object[]{listener2});
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }
}

