/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickList
extends ExternalizableSchemeAdapter
implements SerializableScheme {
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    private static final String ID_TAG = "id";
    private static final String ACTION_TAG = "action";
    static final String DISPLAY_NAME_TAG = "display";
    private static final String DESCRIPTION_TAG = "description";
    private String myDescription;
    private String[] myActionIds = ArrayUtilRt.EMPTY_STRING_ARRAY;
    private SchemeState schemeState;

    QuickList() {
        this.setName("");
    }

    public QuickList(@NotNull String name, @Nullable String description, String[] actionIds) {
        this.setName(name);
        this.myDescription = StringUtil.nullize((String)description);
        this.myActionIds = actionIds;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String value2) {
        this.myDescription = StringUtil.nullize((String)value2);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public void setActionIds(String @NotNull [] value2) {
        this.myActionIds = value2;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)o;
        return Arrays.equals(this.myActionIds, quickList.myActionIds) && Comparing.strEqual((String)this.myDescription, (String)quickList.myDescription) && this.getName().equals(quickList.getName());
    }

    public int hashCode() {
        return 29 * this.getName().hashCode() + Comparing.hashcode((Object)this.myDescription);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getName() + " " + this.getDescription();
    }

    @NotNull
    public String getActionId() {
        return QUICK_LIST_PREFIX + this.getName();
    }

    public void readExternal(@NotNull Element element2) {
        this.setName(element2.getAttributeValue(DISPLAY_NAME_TAG));
        this.myDescription = StringUtil.nullize((String)element2.getAttributeValue(DESCRIPTION_TAG));
        List actionElements = element2.getChildren(ACTION_TAG);
        this.myActionIds = new String[actionElements.size()];
        int n = actionElements.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.myActionIds[i2] = ((Element)actionElements.get(i2)).getAttributeValue(ID_TAG);
        }
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element2 = new Element("list");
        element2.setAttribute(DISPLAY_NAME_TAG, this.getName());
        if (this.myDescription != null) {
            element2.setAttribute(DESCRIPTION_TAG, this.myDescription);
        }
        for (String actionId : this.getActionIds()) {
            element2.addContent(new Element(ACTION_TAG).setAttribute(ID_TAG, actionId));
        }
        this.schemeState = SchemeState.UNCHANGED;
        return element2;
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        return this.schemeState;
    }
}

