/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class PsiSymbolReferenceServiceImpl
implements PsiSymbolReferenceService {
    private static final PsiSymbolReferenceHints EMPTY_HINTS = new PsiSymbolReferenceHints(){};

    PsiSymbolReferenceServiceImpl() {
    }

    @NotNull
    public Iterable<? extends PsiSymbolReference> getReferences(@NotNull PsiElement element2) {
        return (Iterable)CachedValuesManager.getCachedValue((PsiElement)element2, () -> CachedValueProvider.Result.create(Collections.unmodifiableList(this.getReferences(element2, EMPTY_HINTS)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    public <T extends PsiSymbolReference> Collection<T> getReferences(@NotNull PsiElement host, @NotNull Class<T> referenceClass) {
        return this.getReferences(host, PsiSymbolReferenceHints.referenceClassHint(referenceClass));
    }

    @NotNull
    public List<PsiSymbolReference> getReferences(@NotNull PsiElement element2, @NotNull PsiSymbolReferenceHints hints2) {
        ArrayList result2 = ContainerUtil.newArrayList((Iterable)element2.getOwnReferences());
        if (result2.isEmpty() && element2 instanceof PsiExternalReferenceHost) {
            result2.addAll(PsiSymbolReferenceServiceImpl.doGetExternalReferences((PsiExternalReferenceHost)element2, hints2));
        }
        return PsiSymbolReferenceServiceImpl.applyHints(result2, hints2);
    }

    @NotNull
    public Collection<? extends PsiSymbolReference> getExternalReferences(@NotNull PsiExternalReferenceHost element2, @NotNull PsiSymbolReferenceHints hints2) {
        return PsiSymbolReferenceServiceImpl.applyHints(PsiSymbolReferenceServiceImpl.doGetExternalReferences(element2, hints2), hints2);
    }

    @NotNull
    private static List<PsiSymbolReference> doGetExternalReferences(@NotNull PsiExternalReferenceHost element2, @NotNull PsiSymbolReferenceHints hints2) {
        List<PsiSymbolReferenceProviderBean> beans = ReferenceProviders.byLanguage(element2.getLanguage()).byHostClass(element2.getClass());
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        Class requiredReferenceClass = hints2.getReferenceClass();
        SmartList result2 = new SmartList();
        for (PsiSymbolReferenceProviderBean bean : beans) {
            if (requiredReferenceClass != PsiSymbolReference.class && !bean.anyReferenceClass && !requiredReferenceClass.isAssignableFrom(bean.getReferenceClass())) continue;
            result2.addAll(((PsiSymbolReferenceProvider)bean.getInstance()).getReferences(element2, hints2));
        }
        return result2;
    }

    @NotNull
    private static List<PsiSymbolReference> applyHints(@NotNull List<PsiSymbolReference> references, @NotNull PsiSymbolReferenceHints hints2) {
        Integer offsetInElement;
        if (hints2 == EMPTY_HINTS) {
            return references;
        }
        List result2 = references;
        Class referenceClass = hints2.getReferenceClass();
        if (referenceClass != PsiSymbolReference.class) {
            result2 = ContainerUtil.filterIsInstance(result2, (Class)referenceClass);
        }
        if ((offsetInElement = hints2.getOffsetInElement()) != null) {
            result2 = ContainerUtil.filter((Collection)result2, it -> ReferenceRange.containsOffsetInElement((PsiSymbolReference)it, (int)offsetInElement));
        }
        return result2;
    }
}

