/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.encoding;

import com.intellij.ide.DataManager;
import com.intellij.largeFilesEditor.encoding.EncodingWidget;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccessor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingAction
extends com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction {
    private static final Logger logger = Logger.getInstance(ChangeFileEncodingAction.class);
    private final LargeFileEditorAccessor myLargeFileEditorAccessor;
    private final Project project;
    private final StatusBar statusBar;

    ChangeFileEncodingAction(LargeFileEditorAccessor largeFileEditorAccessor, Project project, StatusBar statusBar) {
        this.myLargeFileEditorAccessor = largeFileEditorAccessor;
        this.project = project;
        this.statusBar = statusBar;
    }

    private boolean chosen(@NotNull Charset charset) {
        LargeFileEditorAccess largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.project, this.statusBar);
        if (largeFileEditorAccess == null) {
            logger.warn("tried to change encoding while editor is not accessible");
            return false;
        }
        boolean result2 = largeFileEditorAccess.tryChangeEncoding(charset);
        this.updateWidget();
        return result2;
    }

    private void updateWidget() {
        StatusBarWidget widget = this.statusBar.getWidget("lfeEncoding");
        if (widget instanceof EncodingWidget) {
            ((EncodingWidget)widget).requestUpdate();
        } else {
            logger.warn("[LargeFileEditorSubsystem] ChangeFileEncodingAction.updateWidget(): " + (widget == null ? " variable 'widget' is null" : " variable is instance of " + widget.getClass().getName()));
        }
    }

    @Override
    protected boolean chosen(Document document, Editor editor, @Nullable VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
        return this.chosen(charset);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(true);
    }

    ListPopup createPopup(VirtualFile vFile, Editor editor, Component componentParent) {
        DataContext dataContext = ChangeFileEncodingAction.wrapInDataContext(vFile, editor, componentParent);
        DefaultActionGroup group = this.createActionGroup(vFile, editor, null, null, null);
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplatePresentation().getText(), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    private static DataContext wrapInDataContext(VirtualFile vFile, Editor editor, Component componentParent) {
        DataContext parent = DataManager.getInstance().getDataContext(componentParent);
        return SimpleDataContext.getSimpleContext(ContainerUtil.immutableMapBuilder().put((Object)CommonDataKeys.VIRTUAL_FILE.getName(), (Object)vFile).put((Object)CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), (Object)new VirtualFile[]{vFile}).put((Object)CommonDataKeys.PROJECT.getName(), (Object)editor.getProject()).put((Object)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)editor.getComponent()).build(), parent);
    }
}

