/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.largeFilesEditor.PlatformActionsReplacer;
import com.intellij.largeFilesEditor.editor.EditorModel;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.largeFilesEditor.editor.LargeFileEditorState;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.editor.PropertiesGetter;
import com.intellij.largeFilesEditor.encoding.EncodingWidget;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccessorImpl;
import com.intellij.largeFilesEditor.file.LargeFileManager;
import com.intellij.largeFilesEditor.file.LargeFileManagerImpl;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.LfeSearchManager;
import com.intellij.largeFilesEditor.search.LfeSearchManagerImpl;
import com.intellij.largeFilesEditor.search.RangeSearchCreatorImpl;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeFileEditorImpl
extends UserDataHolderBase
implements LargeFileEditor {
    private static final Logger logger = Logger.getInstance(LargeFileEditorImpl.class);
    private final Project project;
    private LargeFileManager fileManager;
    private final EditorModel editorModel;
    private final DocumentEx document;
    private final VirtualFile vFile;
    private LfeSearchManager searchManager;

    public LargeFileEditorImpl(Project project, VirtualFile vFile) {
        this.vFile = vFile;
        this.project = project;
        int customPageSize = PropertiesGetter.getPageSize();
        int customBorderShift = PropertiesGetter.getMaxPageBorderShiftBytes();
        this.document = LargeFileEditorImpl.createSpecialDocument(vFile);
        this.editorModel = new EditorModel(this.document, project, this.implementDataProviderForEditorModel());
        this.editorModel.putUserDataToEditor(LARGE_FILE_EDITOR_MARK_KEY, new Object());
        this.editorModel.putUserDataToEditor(LARGE_FILE_EDITOR_KEY, this);
        try {
            this.fileManager = new LargeFileManagerImpl(vFile, customPageSize, customBorderShift);
        }
        catch (FileNotFoundException e) {
            logger.warn((Throwable)e);
            this.editorModel.setBrokenMode();
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.open.file.because.file.not.found", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.warning", (Object[])new Object[0]));
            this.requestClosingEditorTab();
            return;
        }
        this.searchManager = new LfeSearchManagerImpl(this, this.fileManager.getFileDataProviderForSearch(), new RangeSearchCreatorImpl());
        this.createAndAddSpecialWidgetIfNeed(project);
        PlatformActionsReplacer.makeAdaptingOfPlatformActionsIfNeed();
        this.editorModel.addCaretListener(new MyCaretListener());
        this.fileManager.addFileChangeListener((lastPage, isLengthIncreased) -> ApplicationManager.getApplication().invokeLater(() -> this.editorModel.onFileChanged(lastPage, isLengthIncreased)));
    }

    private void requestClosingEditorTab() {
        ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.project).closeFile(this.vFile));
    }

    private void createAndAddSpecialWidgetIfNeed(Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        StatusBarWidget existedWidget = statusBar.getWidget("lfeEncoding");
        boolean needToAddNewWidget = false;
        if (existedWidget == null) {
            needToAddNewWidget = true;
        } else if (existedWidget instanceof EncodingWidget && ((EncodingWidget)existedWidget)._getProject() != project) {
            statusBar.removeWidget(existedWidget.ID());
            needToAddNewWidget = true;
        }
        if (needToAddNewWidget) {
            statusBar.addWidget((StatusBarWidget)new EncodingWidget(project, new LargeFileEditorAccessorImpl()));
        }
    }

    @Override
    public LfeSearchManager getSearchManager() {
        return this.searchManager;
    }

    @NotNull
    public JComponent getComponent() {
        return this.editorModel.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.editorModel.getEditor().getContentComponent();
    }

    @NotNull
    public String getName() {
        return "Large File Editor";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state instanceof LargeFileEditorState) {
            LargeFileEditorState largeFileEditorState = (LargeFileEditorState)state;
            this.editorModel.setCaretAndShow(largeFileEditorState.caretPageNumber, largeFileEditorState.caretSymbolOffsetInPage);
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        LargeFileEditorState state = new LargeFileEditorState();
        state.caretPageNumber = this.editorModel.getCaretPageNumber();
        state.caretSymbolOffsetInPage = this.editorModel.getCaretPageOffset();
        return state;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        if (this.searchManager != null) {
            this.searchManager.dispose();
        }
        if (this.fileManager != null) {
            Disposer.dispose((Disposable)this.fileManager);
        }
        this.editorModel.dispose();
        this.vFile.putUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY, null);
    }

    @Override
    public void showSearchResult(SearchResult searchResult) {
        this.editorModel.showSearchResult(searchResult);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public long getCaretPageNumber() {
        return this.editorModel.getCaretPageNumber();
    }

    @Override
    public int getCaretPageOffset() {
        return this.editorModel.getCaretPageOffset();
    }

    @Override
    public Editor getEditor() {
        return this.editorModel.getEditor();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.vFile;
    }

    @Override
    public LargeFileEditorAccess createAccessForEncodingWidget() {
        return new LargeFileEditorAccess(){

            @Override
            @NotNull
            public VirtualFile getVirtualFile() {
                return LargeFileEditorImpl.this.getFile();
            }

            @Override
            @NotNull
            public Editor getEditor() {
                return LargeFileEditorImpl.this.getEditor();
            }

            @Override
            public boolean tryChangeEncoding(@NotNull Charset charset) {
                if (LargeFileEditorImpl.this.fileManager.hasBOM()) {
                    Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.change.encoding.because.it.has.bom.byte.order.mark", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.warning", (Object[])new Object[0]));
                    return false;
                }
                if (LargeFileEditorImpl.this.searchManager.isSearchWorkingNow()) {
                    Messages.showInfoMessage((String)EditorBundle.message((String)"large.file.editor.message.cant.change.encoding.because.search.is.working.now", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.cant.change.encoding", (Object[])new Object[0]));
                    return false;
                }
                LargeFileEditorImpl.this.fileManager.reset(charset);
                LargeFileEditorImpl.this.editorModel.onEncodingChanged();
                return true;
            }

            @Override
            public String getCharsetName() {
                return LargeFileEditorImpl.this.fileManager.getCharsetName();
            }
        };
    }

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return this.fileManager.getFileDataProviderForSearch();
    }

    @Override
    @NotNull
    public EditorModel getEditorModel() {
        return this.editorModel;
    }

    @Override
    public int getPageSize() {
        return this.fileManager.getPageSize();
    }

    private static DocumentEx createSpecialDocument(VirtualFile vFile) {
        DocumentImpl doc = new DocumentImpl("", false, false);
        doc.putUserData(FileDocumentManagerImpl.NOT_RELOADABLE_DOCUMENT_KEY, new Object());
        UndoUtil.disableUndoFor((Document)doc);
        return doc;
    }

    private EditorModel.DataProvider implementDataProviderForEditorModel() {
        return new EditorModel.DataProvider(){

            @Override
            public Page getPage(long pageNumber) throws IOException {
                return LargeFileEditorImpl.this.fileManager.getPage_wait(pageNumber);
            }

            @Override
            public long getPagesAmount() throws IOException {
                return LargeFileEditorImpl.this.fileManager.getPagesAmount();
            }

            @Override
            public Project getProject() {
                return LargeFileEditorImpl.this.project;
            }

            @Override
            public void requestReadPage(long pageNumber, ReadingPageResultHandler readingPageResultHandler) {
                LargeFileEditorImpl.this.fileManager.requestReadPage(pageNumber, readingPageResultHandler);
            }

            @Override
            public List<SearchResult> getSearchResultsInPage(Page page) {
                if (LargeFileEditorImpl.this.searchManager != null) {
                    return LargeFileEditorImpl.this.searchManager.getSearchResultsInPage(page);
                }
                return null;
            }
        };
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            LargeFileEditorImpl.this.searchManager.onCaretPositionChanged(e);
        }
    }
}

