/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.actions;

import com.intellij.largeFilesEditor.actions.Utils;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public abstract class LfeBaseProxyAction
extends AnAction {
    private final AnAction originalAction;

    LfeBaseProxyAction(AnAction originalAction) {
        this.originalAction = originalAction;
        this.copyFrom(originalAction);
    }

    public void update(@NotNull AnActionEvent e) {
        LargeFileEditor largeFileEditor = Utils.tryGetLargeFileEditorManager(e);
        if (largeFileEditor != null) {
            this.updateForLfe(e, largeFileEditor);
        } else {
            this.originalAction.update(e);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LargeFileEditor largeFileEditor = Utils.tryGetLargeFileEditorManager(e);
        if (largeFileEditor != null) {
            this.actionPerformedForLfe(e, largeFileEditor);
        } else {
            this.originalAction.actionPerformed(e);
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        LargeFileEditor largeFileEditor = Utils.tryGetLargeFileEditorManager(e);
        if (largeFileEditor != null) {
            this.updateForLfe(e, largeFileEditor);
        } else {
            this.originalAction.beforeActionPerformedUpdate(e);
        }
    }

    public boolean displayTextInToolbar() {
        return this.originalAction.displayTextInToolbar();
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.originalAction.setDefaultIcon(isDefaultIconSet);
    }

    public boolean isDefaultIcon() {
        return this.originalAction.isDefaultIcon();
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.originalAction.setInjectedContext(worksInInjected);
    }

    public boolean isInInjectedContext() {
        return this.originalAction.isInInjectedContext();
    }

    public boolean isTransparentUpdate() {
        return this.originalAction.isTransparentUpdate();
    }

    public boolean isDumbAware() {
        return this.originalAction.isDumbAware();
    }

    public String toString() {
        return this.originalAction.toString();
    }

    protected abstract void updateForLfe(AnActionEvent var1, @NotNull LargeFileEditor var2);

    protected abstract void actionPerformedForLfe(AnActionEvent var1, @NotNull LargeFileEditor var2);
}

