/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiBuilderUtil {
    private PsiBuilderUtil() {
    }

    public static void advance(PsiBuilder builder2, int count) {
        for (int i2 = 0; i2 < count && !builder2.eof(); ++i2) {
            builder2.getTokenType();
            builder2.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder2, IElementType expectedType) {
        if (builder2.getTokenType() == expectedType) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder2, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers) {
        for (PsiBuilder.Marker marker : markers) {
            if (marker == null) continue;
            marker.drop();
        }
    }

    public static void rollbackTo(@Nullable PsiBuilder.Marker marker) {
        if (marker != null) {
            marker.rollbackTo();
        }
    }

    @NotNull
    public static CharSequence rawTokenText(PsiBuilder builder2, int index) {
        return builder2.getOriginalText().subSequence(builder2.rawTokenTypeStart(index), builder2.rawTokenTypeStart(index + 1));
    }

    @Nullable
    public static PsiBuilder.Marker parseBlockLazy(@NotNull PsiBuilder builder2, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace, @NotNull IElementType codeBlock) {
        if (builder2.getTokenType() != leftBrace) {
            return null;
        }
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        int braceCount = 1;
        while (braceCount > 0 && !builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == leftBrace) {
                ++braceCount;
            } else if (tokenType == rightBrace) {
                --braceCount;
            }
            builder2.advanceLexer();
        }
        marker.collapse(codeBlock);
        if (braceCount > 0) {
            marker.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return marker;
    }

    public static boolean hasProperBraceBalance(@NotNull CharSequence text, @NotNull Lexer lexer, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace) {
        lexer.start(text);
        if (lexer.getTokenType() != leftBrace) {
            return false;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type = lexer.getTokenType();
            if (type == null) {
                return balance == 0;
            }
            if (balance == 0) {
                return false;
            }
            if (type == leftBrace) {
                ++balance;
            } else if (type == rightBrace) {
                --balance;
            }
            lexer.advance();
        }
    }
}

