/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();
    private static final String OPTION_VALUE = "option_value";
    private static final String OPTION_TYPE = "option_type";
    private static final String OPTION_NAME = "option_name";
    private static final String INSPECTION_ID = "inspection_id";

    @NotNull
    public String getGroupId() {
        return "inspections";
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        List<ScopeToolState> tools = InspectionProjectProfileManager.getInstance(project).getCurrentProfile().getAllTools();
        for (ScopeToolState state : tools) {
            InspectionToolWrapper tool = state.getTool();
            PluginInfo pluginInfo = InspectionsUsagesCollector.getInfo(tool);
            if (ENABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, true));
            } else if (DISABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, false));
            }
            result2.addAll(InspectionsUsagesCollector.getChangedSettingsEvents(tool, pluginInfo, state.isEnabled()));
        }
        return result2;
    }

    private static Collection<MetricEvent> getChangedSettingsEvents(InspectionToolWrapper<?, ?> tool, PluginInfo pluginInfo, boolean inspectionEnabled) {
        if (!InspectionsUsagesCollector.isSafeToReport(pluginInfo)) {
            return Collections.emptyList();
        }
        InspectionProfileEntry entry = tool.getTool();
        Map<String, Attribute> options2 = InspectionsUsagesCollector.getOptions(entry);
        if (options2.isEmpty()) {
            return Collections.emptyList();
        }
        Set fields2 = ContainerUtil.map2Set((Collection)ReflectionUtil.collectFields(entry.getClass()), f -> f.getName());
        Map<String, Attribute> defaultOptions = InspectionsUsagesCollector.getOptions((InspectionProfileEntry)ReflectionUtil.newInstance(entry.getClass()));
        ArrayList<MetricEvent> result2 = new ArrayList<MetricEvent>();
        String inspectionId = tool.getID();
        for (Map.Entry<String, Attribute> option2 : options2.entrySet()) {
            Attribute defaultValue;
            String name = option2.getKey();
            Attribute value2 = option2.getValue();
            if (!fields2.contains(name) || value2 == null || (defaultValue = defaultOptions.get(name)) != null && StringUtil.equals((CharSequence)value2.getValue(), (CharSequence)defaultValue.getValue())) continue;
            FeatureUsageData data2 = new FeatureUsageData();
            data2.addData(OPTION_NAME, name);
            data2.addData(INSPECTION_ID, inspectionId);
            data2.addData("inspection_enabled", inspectionEnabled);
            data2.addPluginInfo(pluginInfo);
            if (!InspectionsUsagesCollector.addSettingValue(value2, data2)) continue;
            result2.add(MetricEventFactoryKt.newMetric((String)"setting.non.default.state", (FeatureUsageData)data2));
        }
        return result2;
    }

    private static boolean addSettingValue(Attribute value2, FeatureUsageData data2) {
        try {
            boolean booleanValue = value2.getBooleanValue();
            data2.addData(OPTION_VALUE, booleanValue);
            data2.addData(OPTION_TYPE, "boolean");
            return true;
        }
        catch (DataConversionException e) {
            return InspectionsUsagesCollector.addIntValue(value2, data2);
        }
    }

    private static boolean addIntValue(Attribute value2, FeatureUsageData data2) {
        try {
            int intValue = value2.getIntValue();
            data2.addData(OPTION_VALUE, intValue);
            data2.addData(OPTION_TYPE, "integer");
            return true;
        }
        catch (DataConversionException e) {
            return false;
        }
    }

    @NotNull
    private static MetricEvent create(InspectionToolWrapper<?, ?> tool, PluginInfo info, boolean enabled) {
        FeatureUsageData data2 = new FeatureUsageData().addData("enabled", enabled);
        String language = tool.getLanguage();
        if (StringUtil.isNotEmpty((String)language)) {
            data2.addLanguage(Language.findLanguageByID((String)language));
        }
        if (info != null) {
            data2.addPluginInfo(info);
        }
        data2.addData(INSPECTION_ID, InspectionsUsagesCollector.isSafeToReport(info) ? tool.getID() : "third.party");
        return MetricEventFactoryKt.newMetric((String)"not.default.state", (FeatureUsageData)data2);
    }

    private static boolean isSafeToReport(PluginInfo info) {
        return info != null && info.isSafeToReport();
    }

    @Nullable
    private static PluginInfo getInfo(InspectionToolWrapper<?, ?> tool) {
        InspectionEP extension = tool.getExtension();
        PluginDescriptor pluginDescriptor = extension == null ? null : extension.getPluginDescriptor();
        return pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
    }

    private static Map<String, Attribute> getOptions(InspectionProfileEntry entry) {
        Element element2 = new Element("options");
        try {
            ScopeToolState.tryWriteSettings((InspectionProfileEntry)entry, (Element)element2);
            List options2 = element2.getContent();
            if (options2.isEmpty()) {
                return Collections.emptyMap();
            }
            return ContainerUtil.map2MapNotNull((Collection)options2, option2 -> {
                if (option2 instanceof Element) {
                    Attribute nameAttr = ((Element)option2).getAttribute("name");
                    Attribute valueAttr = ((Element)option2).getAttribute("value");
                    if (nameAttr != null && valueAttr != null) {
                        return Pair.create((Object)nameAttr.getValue(), (Object)valueAttr);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static class InspectionToolValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "tool".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (InspectionToolValidator.isThirdPartyValue((String)data2)) {
                return ValidationResultType.ACCEPTED;
            }
            return InspectionToolValidator.acceptWhenReportedByPluginFromPluginRepository((EventContext)context);
        }
    }
}

