/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventField;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventId3;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

public class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";
    private final EventLogGroup GROUP = new EventLogGroup("file.types", 3);
    private final EventId3<Object, String, Integer> FILE_IN_PROJECT = this.GROUP.registerEvent("file.in.project", EventFields.PluginInfoFromInstance, (EventField)EventFields.String((String)"file_type").withCustomRule("file_type"), (EventField)EventFields.Int((String)"count"));

    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public CancellablePromise<Set<MetricEvent>> getMetrics(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        HashSet events = new HashSet();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            return Promises.resolvedCancellablePromise(Collections.emptySet());
        }
        FileType[] registeredFileTypes = fileTypeManager.getRegisteredFileTypes();
        ArrayList<CancellablePromise> promises = new ArrayList<CancellablePromise>(registeredFileTypes.length);
        for (FileType fileType : registeredFileTypes) {
            if (project.isDisposed()) {
                return Promises.resolvedCancellablePromise(Collections.emptySet());
            }
            promises.add(ReadAction.nonBlocking(() -> {
                IProjectStore stateStore = ProjectKt.getStateStore(project);
                Ref counter = new Ref((Object)0);
                FileTypeIndex.processFiles((FileType)fileType, file2 -> {
                    ProgressManager.checkCanceled();
                    if (!stateStore.isProjectFile((VirtualFile)file2)) {
                        counter.set((Object)((Integer)counter.get() + 1));
                    }
                    return true;
                }, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                Integer count = (Integer)counter.get();
                if (count != 0) {
                    events.add(this.FILE_IN_PROJECT.metric((Object)fileType, (Object)FileTypeUsagesCollector.getSafeFileTypeName(fileType), (Object)StatisticsUtil.getNextPowerOfTwo((int)count)));
                }
            }).wrapProgress(indicator).expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance()));
        }
        return (CancellablePromise)Promises.all(promises).then(o -> events);
    }

    @NotNull
    public static FeatureUsageData newFeatureUsageData(@NotNull FileType type) {
        FeatureUsageData data2 = new FeatureUsageData();
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
        data2.addPluginInfo(info);
        data2.addData("file_type", FileTypeUsagesCollector.getSafeFileTypeName(type));
        return data2;
    }

    public static String getSafeFileTypeName(@NotNull FileType fileType) {
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(fileType.getClass());
        return info.isDevelopedByJetBrains() ? fileType.getName() : DEFAULT_ID;
    }

    public static class ValidationRule
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "file_type".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (ValidationRule.isThirdPartyValue((String)data2)) {
                return ValidationResultType.ACCEPTED;
            }
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(data2);
            if (fileType == null || !StringUtil.equals((CharSequence)fileType.getName(), (CharSequence)data2)) {
                return ValidationResultType.REJECTED;
            }
            boolean isDevelopedByJB = PluginInfoDetectorKt.getPluginInfo(fileType.getClass()).isDevelopedByJetBrains();
            return isDevelopedByJB ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }
    }
}

