/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionsBuiltInWhitelist {
    private static final ActionsBuiltInWhitelist ourInstance = new ActionsBuiltInWhitelist();
    private final Set<String> ourXmlActionIds = new HashSet<String>();
    private final Set<String> ourCustomActionWhitelist = ContainerUtil.newHashSet((Object[])new String[]{"ShowUsagesPopup.showSettings", "Reload Classes", "DialogCancelAction", "DialogOkAction", "DoubleShortcut"});

    static ActionsBuiltInWhitelist getInstance() {
        return ourInstance;
    }

    private ActionsBuiltInWhitelist() {
    }

    public boolean isCustomAllowedAction(@NotNull String actionId) {
        return this.ourCustomActionWhitelist.contains(actionId);
    }

    public boolean isWhitelistedActionId(@NotNull String actionId) {
        return this.isCustomAllowedAction(actionId) || this.ourXmlActionIds.contains(actionId);
    }

    public void addActionLoadedFromXml(@NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
        PluginInfo pluginInfo;
        PluginInfo pluginInfo2 = pluginInfo = plugin == null ? null : PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
        if (pluginInfo != null && pluginInfo.isSafeToReport()) {
            this.ourXmlActionIds.add(actionId);
        }
    }

    public void addActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        PluginDescriptor plugin;
        if (keymap2 instanceof DefaultKeymapImpl && PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)(plugin = ((DefaultKeymapImpl)keymap2).getPlugin())).isDevelopedByJetBrains()) {
            this.ourXmlActionIds.addAll(actionIds);
        }
    }
}

