/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TypingEventsLogger
implements AnActionListener {
    public static final String GROUP_ID = "editor.typing";
    public static final EventsRateWindowThrottle ourThrottle = new EventsRateWindowThrottle(2000, 3600000L, System.currentTimeMillis());

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
        EventRateThrottleResult result2 = ourThrottle.tryPass(System.currentTimeMillis());
        if (result2 == EventRateThrottleResult.ACCEPT) {
            TypingEventsLogger.logTypingEvent(dataContext, "typed");
        } else if (result2 == EventRateThrottleResult.DENY_AND_REPORT) {
            TypingEventsLogger.logTypingEvent(dataContext, "too.many.events");
        }
    }

    private static void logTypingEvent(@NotNull DataContext dataContext, @NotNull String eventId) {
        Project project = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, eventId);
    }
}

