/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "platform.registry";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return RegistryApplicationUsagesCollector.getChangedValuesUsages();
    }

    @NotNull
    static Set<MetricEvent> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault()).map(key -> MetricEventFactoryKt.newMetric((String)"registry", (FeatureUsageData)new FeatureUsageData().addData("id", key.getKey()))).collect(Collectors.toSet());
        Set experiments = Experiments.EP_NAME.extensions().filter(f -> Experiments.getInstance().isFeatureEnabled(f.id)).map(f -> MetricEventFactoryKt.newMetric((String)"experiment", (FeatureUsageData)new FeatureUsageData().addData("id", f.id))).collect(Collectors.toSet());
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>(registry);
        result2.addAll(experiments);
        return result2;
    }

    public static class RegistryUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "registry_key".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            ExperimentalFeature feature = RegistryUtilValidator.findFeatureById(data2);
            if (feature != null) {
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(feature.getClass());
                context.setPluginInfo(info);
                return info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            PluginInfo info = RegistryUtilValidator.getPluginInfoByRegistry(Registry.get((String)data2));
            context.setPluginInfo(info);
            return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }

        @NotNull
        private static PluginInfo getPluginInfoByRegistry(@NotNull RegistryValue value2) {
            String pluginId = value2.getPluginId();
            return pluginId != null ? PluginInfoDetectorKt.getPluginInfoById((PluginId)PluginId.getId((String)pluginId)) : PluginInfoDetectorKt.getPlatformPlugin();
        }

        @Nullable
        private static ExperimentalFeature findFeatureById(@NotNull String featureId) {
            for (ExperimentalFeature feature : (ExperimentalFeature[])Experiments.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)feature.id, (CharSequence)featureId)) continue;
                return feature;
            }
            return null;
        }
    }
}

