/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.uploader.EventLogExternalUploader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public class EventLogApplicationLifecycleListener
implements AppLifecycleListener {
    @Override
    public void appWillBeClosed(boolean isRestart) {
        StatisticsEventLoggerProvider config2;
        if (!isRestart && !PluginManagerCore.isRunningFromSources() && EventLogApplicationLifecycleListener.isSendingOnExitEnabled() && (config2 = FeatureUsageLogger.INSTANCE.getConfig()).isSendEnabled() && !EventLogApplicationLifecycleListener.isUpdateInProgress()) {
            ProgressManager.getInstance().run((Task)new Task.Modal(null, "Starting External Log Uploader", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    EventLogExternalUploader.INSTANCE.startExternalUpload(config2.getRecorderId(), false);
                }
            });
        }
    }

    private static boolean isSendingOnExitEnabled() {
        return Registry.get((String)"feature.usage.event.log.send.on.ide.close").asBoolean();
    }

    private static boolean isUpdateInProgress() {
        return ApplicationInfo.getInstance().getBuild().asString().equals(PropertiesComponent.getInstance().getValue("ide.self.update.started.for.build"));
    }
}

