/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.internal.cachedValueProfiler.CachedValueProfilerDumper;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class DumpCachedValueProfilerInfoAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DumpCachedValueProfilerInfoAction.dumpResults(project);
    }

    static void dumpResults(Project project) {
        try {
            File file2 = CachedValueProfilerDumper.dumpResults(new File(PathManager.getLogPath()));
            String url = FileUtil.getUrl((File)file2);
            String message = MessageFormat.format("Cached value snapshot ''{0}'' is captured. <a href=\"{1}\">Show in {2}</a>.", file2, url, RevealFileAction.getFileManagerName());
            Holder.GROUP.createNotification("", message, NotificationType.INFORMATION, RevealFileAction.FILE_SELECTING_LISTENER).notify(project);
        }
        catch (IOException exception) {
            Holder.GROUP.createNotification("Failed to capture snapshot: " + exception.getMessage(), NotificationType.ERROR).notify(project);
        }
    }

    private static class Holder {
        private static final NotificationGroup GROUP = new NotificationGroup("Cached value profiling", NotificationDisplayType.BALLOON, false);

        private Holder() {
        }
    }
}

