/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AddInlayInternalAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        if (editor == null) {
            return;
        }
        List<Caret> carets = editor.getCaretModel().getAllCarets();
        if (carets.isEmpty()) {
            return;
        }
        String inlayText = Messages.showInputDialog((String)"Inlay text:", (String)(carets.size() > 1 ? "Add Inlays" : "Add Inlay"), (Icon)Messages.getInformationIcon());
        if (inlayText == null) {
            return;
        }
        int[] offsets2 = StreamEx.of(carets).mapToInt(Caret::getOffset).toArray();
        InlayModelImpl model = editor.getInlayModel();
        for (int offset : offsets2) {
            final AtomicReference<Inlay> ref = new AtomicReference<Inlay>();
            MenuOnClickPresentation presentation2 = new MenuOnClickPresentation(new PresentationFactory(editor).text(inlayText), project, (Function0<? extends List<? extends AnAction>>)((Function0)() -> Collections.singletonList(new AnAction(InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.text.remove", new Object[0]), InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.description.remove.this.inlay", new Object[0]), AllIcons.Actions.Cancel){

                public void actionPerformed(@NotNull AnActionEvent e1) {
                    Inlay inlay = (Inlay)ref.get();
                    if (inlay != null) {
                        Disposer.dispose((Disposable)inlay);
                    }
                }
            })));
            Inlay inlay = model.addInlineElement(offset, new PresentationRenderer(presentation2));
            ref.set(inlay);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        presentation2.setEnabled(project != null && editor != null);
    }
}

