/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeFileChooserDialog
extends DialogWrapper
implements TreeFileChooser {
    private Tree myTree;
    private PsiFile mySelectedFile = null;
    private final Project myProject;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    @Nullable
    private final PsiFile myInitialFile;
    @Nullable
    private final TreeFileChooser.PsiFileFilter myFilter;
    @Nullable
    private final FileType myFileType;
    private final boolean myDisableStructureProviders;
    private final boolean myShowLibraryContents;
    private boolean mySelectSearchByNameTab = false;

    public TreeFileChooserDialog(@NotNull Project project, @NlsContexts.DialogTitle String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter2, boolean disableStructureProviders, boolean showLibraryContents) {
        super(project, true);
        this.myInitialFile = initialFile;
        this.myFilter = filter2;
        this.myFileType = fileType;
        this.myDisableStructureProviders = disableStructureProviders;
        this.myShowLibraryContents = showLibraryContents;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        if (initialFile != null) {
            SwingUtilities.invokeLater(() -> this.selectFile(initialFile));
        }
        SwingUtilities.invokeLater(() -> this.handleSelectionChanged());
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            @Override
            public Object @NotNull [] getChildElements(@NotNull Object element2) {
                return TreeFileChooserDialog.this.filterFiles(super.getChildElements(element2));
            }

            public boolean isShowLibraryContents() {
                return TreeFileChooserDialog.this.myShowLibraryContents;
            }

            public boolean isShowModules() {
                return false;
            }

            @Override
            public List<TreeStructureProvider> getProviders() {
                return TreeFileChooserDialog.this.myDisableStructureProviders ? null : super.getProviders();
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, (Comparator<NodeDescriptor<?>>)AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreeFileChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                TreePath path = TreeFileChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path != null && TreeFileChooserDialog.this.myTree.isPathSelected(path)) {
                    TreeFileChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        if (this.myInitialFile != null) {
            name = this.myInitialFile.getName();
        }
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, new MyGotoFileModel(), name, true, (PsiElement)this.myInitialFile){

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    TreeFileChooserDialog.this.doOKAction();
                } else {
                    TreeFileChooserDialog.this.doCancelAction();
                }
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback2, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)TreeFileChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
                if (TreeFileChooserDialog.this.mySelectSearchByNameTab) {
                    TreeFileChooserDialog.this.myTabbedPane.setSelectedIndex(1);
                }
            }

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void chosenElementMightChange() {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        };
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        SwingUtilities.invokeLater(() -> this.myGotoByNamePanel.invoke(new MyCallback(), ModalityState.stateForComponent((Component)this.getRootPane()), false));
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    public void selectSearchByNameTab() {
        this.mySelectSearchByNameTab = true;
    }

    private void handleSelectionChanged() {
        PsiFile selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    protected void doOKAction() {
        this.mySelectedFile = this.calcSelectedClass();
        if (this.mySelectedFile == null) {
            return;
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        this.mySelectedFile = null;
        super.doCancelAction();
    }

    public PsiFile getSelectedFile() {
        return this.mySelectedFile;
    }

    public void selectFile(@NotNull PsiFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myBuilder != null) {
                this.myBuilder.selectAsync(file2, file2.getVirtualFile(), true);
            }
        }, ModalityState.stateForComponent((Component)this.getWindow()));
    }

    public void showDialog() {
        this.show();
    }

    private PsiFile calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 1) {
            return (PsiFile)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ProjectViewNode)) {
            return null;
        }
        ProjectViewNode pvNode = (ProjectViewNode)userObject;
        VirtualFile vFile = pvNode.getVirtualFile();
        if (vFile != null && !vFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        }
        return null;
    }

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeFileChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private Object[] filterFiles(Object[] list2) {
        Condition condition = psiFile -> {
            if (this.myFilter != null && !this.myFilter.accept(psiFile)) {
                return false;
            }
            boolean accepted = this.myFileType == null || psiFile.getFileType() == this.myFileType;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && !accepted) {
                accepted = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.myFileType);
            }
            return accepted;
        };
        ArrayList<Object> result2 = new ArrayList<Object>(list2.length);
        for (Object o : list2) {
            ProjectViewNode projectViewNode;
            Object psiFile2 = o instanceof PsiFile ? (PsiFile)o : (o instanceof PsiFileNode ? (PsiFile)((PsiFileNode)((Object)o)).getValue() : null);
            if (psiFile2 != null && !condition.value(psiFile2) || o instanceof ProjectViewNode && !(projectViewNode = (ProjectViewNode)o).canHaveChildrenMatching(condition)) continue;
            result2.add(o);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    private final class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element2) {
            TreeFileChooserDialog.this.mySelectedFile = (PsiFile)element2;
            TreeFileChooserDialog.this.close(0);
        }
    }

    private final class MyGotoFileModel
    implements ChooseByNameModel,
    DumbAware {
        private final int myMaxSize;

        private MyGotoFileModel() {
            this.myMaxSize = WindowManagerEx.getInstanceEx().getFrame((Project)((TreeFileChooserDialog)TreeFileChooserDialog.this).myProject).getSize().width;
        }

        public Object @NotNull [] getElementsByName(@NotNull String name, boolean checkBoxState, @NotNull String pattern) {
            GlobalSearchScope scope = TreeFileChooserDialog.this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)TreeFileChooserDialog.this.myProject) : GlobalSearchScope.projectScope((Project)TreeFileChooserDialog.this.myProject);
            Object[] psiFiles = FilenameIndex.getFilesByName((Project)TreeFileChooserDialog.this.myProject, (String)name, (GlobalSearchScope)scope);
            return TreeFileChooserDialog.this.filterFiles(psiFiles);
        }

        public String getPromptText() {
            return IdeBundle.message((String)"prompt.filechooser.enter.file.name", (Object[])new Object[0]);
        }

        public String getCheckBoxName() {
            return null;
        }

        @NotNull
        public String getNotInMessage() {
            return "";
        }

        @NotNull
        public String getNotFoundMessage() {
            return "";
        }

        public boolean loadInitialCheckBoxState() {
            return true;
        }

        public void saveInitialCheckBoxState(boolean state) {
        }

        @NotNull
        public PsiElementListCellRenderer getListCellRenderer() {
            return new GotoFileCellRenderer(this.myMaxSize);
        }

        public String @NotNull [] getNames(boolean checkBoxState) {
            String[] fileNames;
            if (TreeFileChooserDialog.this.myFileType != null && TreeFileChooserDialog.this.myProject != null) {
                GlobalSearchScope scope = TreeFileChooserDialog.this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)TreeFileChooserDialog.this.myProject) : GlobalSearchScope.projectScope((Project)TreeFileChooserDialog.this.myProject);
                Collection virtualFiles = FileTypeIndex.getFiles((FileType)TreeFileChooserDialog.this.myFileType, (GlobalSearchScope)scope);
                fileNames = (String[])ContainerUtil.map2Array((Collection)virtualFiles, String.class, file2 -> file2.getName());
            } else {
                fileNames = FilenameIndex.getAllFilenames((Project)TreeFileChooserDialog.this.myProject);
            }
            THashSet array2 = new THashSet();
            Collections.addAll(array2, fileNames);
            Object[] result2 = ArrayUtilRt.toStringArray((Collection)array2);
            Arrays.sort(result2);
            return result2;
        }

        public boolean willOpenEditor() {
            return true;
        }

        public String getElementName(@NotNull Object element2) {
            if (!(element2 instanceof PsiFile)) {
                return null;
            }
            return ((PsiFile)element2).getName();
        }

        @Nullable
        public String getFullName(@NotNull Object element2) {
            if (element2 instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)element2).getVirtualFile();
                return virtualFile != null ? virtualFile.getPath() : null;
            }
            return this.getElementName(element2);
        }

        public String getHelpId() {
            return null;
        }

        public String @NotNull [] getSeparators() {
            return new String[]{"/", "\\"};
        }

        public boolean useMiddleMatching() {
            return false;
        }
    }
}

