/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorHelper {
    public static <T extends PsiElement> void openFilesInEditor(T @NotNull [] elements2) {
        int limit = EditorWindow.getTabLimit();
        int max = Math.min(limit, elements2.length);
        for (int i2 = 0; i2 < max; ++i2) {
            EditorHelper.openInEditor(elements2[i2], true);
        }
    }

    public static Editor openInEditor(@NotNull PsiElement element2) {
        FileEditor editor = EditorHelper.openInEditor(element2, true);
        return editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
    }

    @Nullable
    public static FileEditor openInEditor(@NotNull PsiElement element2, boolean switchToText) {
        return EditorHelper.openInEditor(element2, switchToText, false);
    }

    @Nullable
    public static FileEditor openInEditor(@NotNull PsiElement element2, boolean switchToText, boolean focusEditor) {
        int offset;
        PsiFile file2;
        if (element2 instanceof PsiFile) {
            file2 = (PsiFile)element2;
            offset = -1;
        } else {
            file2 = element2.getContainingFile();
            offset = element2.getTextOffset();
        }
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(element2.getProject(), virtualFile, offset);
        Project project = element2.getProject();
        if (offset == -1 && !switchToText) {
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, focusEditor);
        } else {
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, focusEditor);
        }
        return FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
    }
}

